/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.PrintStream;
import java.nio.file.Path;
import org.neo4j.cli.ExecutionContext;
import picocli.CommandLine;

public class ConsistencyCheckOptions {
    @CommandLine.Option(names={"--report-dir"}, paramLabel="<path>", description={"Directory where consistency report will be written."}, defaultValue=".")
    private Path reportDir;
    @CommandLine.Option(names={"--check-graph"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Perform consistency checks between nodes, relationships, properties, types and tokens."})
    private boolean checkGraph = true;
    @CommandLine.Option(names={"--check-indexes"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Perform consistency checks on indexes."})
    private boolean checkIndexes = true;
    @CommandLine.Option(names={"--check-index-structure"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Perform structure checks on indexes."})
    private boolean checkIndexStructure = true;
    @CommandLine.Option(names={"--check-label-scan-store"}, arity="1", paramLabel="<true/false>", description={"Perform consistency checks on the label scan store. This option is deprecated and its value will be ignored. Checking of label scan store/lookup index on labels is controlled by --check-graph."})
    private boolean checkLabelScanStore = true;
    @CommandLine.Option(names={"--check-relationship-type-scan-store"}, arity="1", paramLabel="<true/false>", description={"Perform consistency checks on the relationship type scan store. This option is deprecated and its value will be ignored. Checking of relationship type scan store/lookup index on relationship types is controlled by --check-graph."})
    private boolean checkRelationshipTypeScanStore;
    @CommandLine.Option(names={"--check-property-owners"}, arity="1", paramLabel="<true/false>", description={"Perform additional consistency checks on property ownership. This check is @|bold,red very|@ expensive in time and memory. This option is deprecated and its value will be ignored."})
    private boolean checkPropertyOwners;

    public Path getReportDir() {
        return this.reportDir;
    }

    public boolean isCheckGraph() {
        return this.checkGraph;
    }

    public boolean isCheckIndexes() {
        return this.checkIndexes;
    }

    public boolean isCheckIndexStructure() {
        return this.checkIndexStructure;
    }

    public void warnOnUsageOfDeprecatedOptions(CommandLine.Model.CommandSpec spec, ExecutionContext ctx) {
        CommandLine.ParseResult parseResult = spec.commandLine().getParseResult();
        PrintStream out = ctx.out();
        this.checkUsageOfDeprecatedOption(parseResult, out, "--check-label-scan-store");
        this.checkUsageOfDeprecatedOption(parseResult, out, "--check-relationship-type-scan-store");
        this.checkUsageOfDeprecatedOption(parseResult, out, "--check-property-owners");
    }

    private void checkUsageOfDeprecatedOption(CommandLine.ParseResult parseResult, PrintStream out, String deprecatedOption) {
        if (parseResult.hasMatchedOption(deprecatedOption)) {
            out.println("Warning: Option '" + deprecatedOption + "' has been deprecated and its value will be ignored.");
        }
    }
}

