/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.memory.MemoryTracker;

class DynamicNodeLabelsCache
implements AutoCloseable {
    private final IntArray cache;
    private final AtomicLong nextIndex = new AtomicLong();

    DynamicNodeLabelsCache(MemoryTracker memoryTracker) {
        this.cache = NumberArrayFactories.OFF_HEAP.newDynamicIntArray(100000L, 0, memoryTracker);
    }

    long put(long[] labels) {
        long index = this.nextIndex.getAndAdd(labels.length + 1);
        this.cache.set(index, labels.length);
        for (int i = 0; i < labels.length; ++i) {
            this.cache.set(index + 1L + (long)i, Math.toIntExact(labels[i]));
        }
        return index;
    }

    long[] get(long index, long[] into) {
        int count = this.cache.get(index);
        if (count > into.length) {
            into = Arrays.copyOf(into, count);
        }
        for (int i = 0; i < count; ++i) {
            into[i] = this.cache.get(index + 1L + (long)i);
        }
        if (count < into.length) {
            into[count] = -1L;
        }
        return into;
    }

    void clear() {
        this.cache.clear();
        this.nextIndex.set(0L);
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

