/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.token.TokenHolders;

public class IndexAccessors
implements Closeable {
    private static final String CONSISTENCY_INDEX_ACCESSOR_BUILDER_TAG = "consistencyIndexAccessorBuilder";
    private final MutableLongObjectMap<IndexAccessor> accessors = new LongObjectHashMap();
    private final List<IndexDescriptor> onlineIndexRules = new ArrayList<IndexDescriptor>();
    private final List<IndexDescriptor> notOnlineIndexRules = new ArrayList<IndexDescriptor>();

    public IndexAccessors(IndexProviderMap providers, NeoStores neoStores, IndexSamplingConfig samplingConfig, PageCacheTracer pageCacheTracer, TokenNameLookup tokenNameLookup) throws IOException {
        this(providers, neoStores, samplingConfig, null, pageCacheTracer, tokenNameLookup);
    }

    public IndexAccessors(IndexProviderMap providers, NeoStores neoStores, IndexSamplingConfig samplingConfig, IndexAccessorLookup accessorLookup, PageCacheTracer pageCacheTracer, TokenNameLookup tokenNameLookup) throws IOException {
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(CONSISTENCY_INDEX_ACCESSOR_BUILDER_TAG);){
            TokenHolders tokenHolders = StoreTokens.readOnlyTokenHolders((NeoStores)neoStores, (PageCursorTracer)cursorTracer);
            Iterator indexes = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)neoStores.getSchemaStore(), (TokenHolders)tokenHolders).indexesGetAll(cursorTracer);
            while (true) {
                try {
                    while (indexes.hasNext()) {
                        IndexDescriptor indexDescriptor = (IndexDescriptor)indexes.next();
                        if (indexDescriptor.isUnique() && indexDescriptor.getOwningConstraintId().isEmpty()) {
                            this.notOnlineIndexRules.add(indexDescriptor);
                            continue;
                        }
                        if (InternalIndexState.ONLINE == this.provider(providers, indexDescriptor).getInitialState(indexDescriptor, cursorTracer)) {
                            this.onlineIndexRules.add(indexDescriptor);
                            continue;
                        }
                        this.notOnlineIndexRules.add(indexDescriptor);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
        accessorLookup = accessorLookup != null ? accessorLookup : index -> this.provider(providers, index).getOnlineAccessor(index, samplingConfig, tokenNameLookup);
        for (IndexDescriptor indexRule : this.onlineIndexRules) {
            long indexId = indexRule.getId();
            this.accessors.put(indexId, (Object)accessorLookup.apply(indexRule));
        }
    }

    private IndexProvider provider(IndexProviderMap providers, IndexDescriptor indexRule) {
        return providers.lookup(indexRule.getIndexProvider());
    }

    public Collection<IndexDescriptor> notOnlineRules() {
        return this.notOnlineIndexRules;
    }

    public IndexAccessor accessorFor(IndexDescriptor indexRule) {
        return (IndexAccessor)this.accessors.get(indexRule.getId());
    }

    public List<IndexDescriptor> onlineRules() {
        return this.onlineIndexRules;
    }

    public List<IndexDescriptor> onlineRules(EntityType entityType) {
        return this.onlineIndexRules.stream().filter(index -> index.schema().entityType() == entityType).collect(Collectors.toList());
    }

    public IndexReaders readers() {
        return new IndexReaders();
    }

    public void remove(IndexDescriptor descriptor) {
        IndexAccessor remove = (IndexAccessor)this.accessors.remove(descriptor.getId());
        if (remove != null) {
            remove.close();
        }
        this.onlineIndexRules.remove(descriptor);
        this.notOnlineIndexRules.remove(descriptor);
    }

    @Override
    public void close() {
        try {
            IOUtils.closeAllUnchecked((Collection)this.accessors.toList());
        }
        finally {
            this.accessors.clear();
            this.onlineIndexRules.clear();
            this.notOnlineIndexRules.clear();
        }
    }

    public static interface IndexAccessorLookup {
        public IndexAccessor apply(IndexDescriptor var1) throws IOException;
    }

    public class IndexReaders
    implements AutoCloseable {
        private final MutableLongObjectMap<IndexReader> readers = new LongObjectHashMap();

        public IndexReader reader(IndexDescriptor index) {
            long indexId = index.getId();
            IndexReader reader = (IndexReader)this.readers.get(indexId);
            if (reader == null) {
                reader = ((IndexAccessor)IndexAccessors.this.accessors.get(indexId)).newReader();
                this.readers.put(indexId, (Object)reader);
            }
            return reader;
        }

        @Override
        public void close() {
            IOUtils.closeAllUnchecked((Collection)this.readers.values());
            this.readers.clear();
        }
    }
}

