/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.checking.DebugContext;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.internal.SchemaIndexExtensionLoader;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.AccessStatsKeepingStoreAccess;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.statistics.VerboseStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.TokenScanStore;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class ConsistencyCheckService {
    private static final String CONSISTENCY_TOKEN_READER_TAG = "consistencyTokenReader";
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Deprecated
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, tuningConfiguration, progressFactory, logProvider, verbose, ConsistencyFlags.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        try {
            Result result = this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, (FileSystemAbstraction)fileSystem, verbose, consistencyFlags);
            return result;
        }
        finally {
            try {
                fileSystem.close();
            }
            catch (IOException e) {
                Log log = logProvider.getLog(this.getClass());
                log.error("Failure during shutdown of file system", (Throwable)e);
            }
        }
    }

    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, verbose, ConsistencyCheckService.defaultReportDir(config), consistencyFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, Path reportDir, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        Log log = logProvider.getLog(this.getClass());
        JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;
        EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, pageCacheTracer, logProvider.getLog(PageCache.class), EmptyVersionContextSupplier.EMPTY, jobScheduler, Clocks.nanoClock(), new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            Result result = this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, pageCache, verbose, reportDir, consistencyFlags, pageCacheTracer, (MemoryTracker)memoryTracker);
            return result;
        }
        finally {
            try {
                pageCache.close();
            }
            catch (Exception e) {
                log.error("Failure during shutdown of the page cache", (Throwable)e);
            }
            try {
                jobScheduler.close();
            }
            catch (Exception e) {
                log.error("Failure during shutdown of the job scheduler", (Throwable)e);
            }
        }
    }

    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, ConsistencyFlags consistencyFlags, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, pageCache, verbose, ConsistencyCheckService.defaultReportDir(config), consistencyFlags, pageCacheTracer, memoryTracker);
    }

    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, final boolean verbose, Path reportDir, ConsistencyFlags consistencyFlags, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        DebugContext debugContext = new DebugContext(){

            @Override
            public boolean debugEnabled() {
                return verbose;
            }

            @Override
            public void debug(String message) {
                System.out.println(message);
            }
        };
        return this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, pageCache, debugContext, reportDir, consistencyFlags, pageCacheTracer, memoryTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, DebugContext debugContext, Path reportDir, ConsistencyFlags consistencyFlags, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        this.assertRecovered(databaseLayout, config, fileSystem, memoryTracker);
        Log log = logProvider.getLog(this.getClass());
        config.set(GraphDatabaseSettings.read_only, (Object)true);
        config.set(GraphDatabaseSettings.pagecache_warmup_enabled, (Object)false);
        LifeSupport life = new LifeSupport();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate());
        StoreFactory factory = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fileSystem, logProvider, pageCacheTracer);
        CountsManager countsManager = new CountsManager(pageCache, fileSystem, databaseLayout, pageCacheTracer, memoryTracker);
        life.add((Lifecycle)countsManager);
        Path reportFile = this.chooseReportPath(reportDir);
        Log4jLogProvider reportLogProvider = new Log4jLogProvider(LogConfig.createBuilder((FileSystemAbstraction)fileSystem, (Path)reportFile, (Level)Level.INFO).createOnDemand().withCategory(false).build());
        Log reportLog = reportLogProvider.getLog(this.getClass());
        Monitors monitors = new Monitors();
        JobScheduler jobScheduler = (JobScheduler)life.add((Lifecycle)JobSchedulerFactory.createInitialisedScheduler());
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "Label"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "RelationshipType"));
        RecoveryCleanupWorkCollector workCollector = RecoveryCleanupWorkCollector.ignore();
        DatabaseExtensions extensions = (DatabaseExtensions)life.add((Lifecycle)SchemaIndexExtensionLoader.instantiateExtensions(databaseLayout, fileSystem, config, (LogService)new SimpleLogService(logProvider), pageCache, jobScheduler, workCollector, DbmsInfo.TOOL, monitors, tokenHolders));
        DefaultIndexProviderMap indexes = (DefaultIndexProviderMap)life.add((Lifecycle)new DefaultIndexProviderMap((DependencyResolver)extensions, config));
        try (NeoStores neoStores = factory.openAllNeoStores();){
            StoreAccess storeAccess;
            Statistics statistics;
            try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(CONSISTENCY_TOKEN_READER_TAG);){
                tokenHolders.setInitialTokens(StoreTokens.allReadableTokens((NeoStores)neoStores), cursorTracer);
            }
            life.start();
            LabelScanStore labelScanStore = TokenScanStore.labelScanStore((PageCache)pageCache, (DatabaseLayout)databaseLayout, (FileSystemAbstraction)fileSystem, (FullStoreChangeStream)FullStoreChangeStream.EMPTY, (boolean)true, (Monitors)monitors, (RecoveryCleanupWorkCollector)workCollector, (PageCacheTracer)pageCacheTracer, (MemoryTracker)memoryTracker);
            RelationshipTypeScanStore relationshipTypeScanstore = TokenScanStore.toggledRelationshipTypeScanStore((PageCache)pageCache, (DatabaseLayout)databaseLayout, (FileSystemAbstraction)fileSystem, (FullStoreChangeStream)FullStoreChangeStream.EMPTY, (boolean)true, (Monitors)monitors, (RecoveryCleanupWorkCollector)workCollector, (Config)config, (PageCacheTracer)pageCacheTracer, (MemoryTracker)memoryTracker);
            life.add((Lifecycle)labelScanStore);
            life.add((Lifecycle)relationshipTypeScanstore);
            IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(pageCache, databaseLayout, workCollector, true, pageCacheTracer);
            life.add((Lifecycle)indexStatisticsStore);
            int numberOfThreads = ConsistencyCheckService.defaultConsistencyCheckThreadsNumber();
            AccessStatistics stats = new AccessStatistics();
            if (debugContext.debugEnabled()) {
                statistics = new VerboseStatistics(stats, new DefaultCounts(numberOfThreads), log);
                storeAccess = new AccessStatsKeepingStoreAccess(neoStores, stats);
            } else {
                statistics = Statistics.NONE;
                storeAccess = new StoreAccess(neoStores);
            }
            storeAccess.initialize();
            DirectStoreAccess stores = new DirectStoreAccess(storeAccess, labelScanStore, relationshipTypeScanstore, (IndexProviderMap)indexes, tokenHolders, indexStatisticsStore, (IdGeneratorFactory)idGeneratorFactory);
            double memoryLimitLeewayFactor = (Double)config.get(GraphDatabaseInternalSettings.consistency_check_memory_limit_factor);
            FullCheck check = new FullCheck(progressFactory, statistics, numberOfThreads, consistencyFlags, config, debugContext, NodeBasedMemoryLimiter.defaultWithLeeway(memoryLimitLeewayFactor));
            summary = check.execute(pageCache, stores, countsManager, null, pageCacheTracer, memoryTracker, (Log)new DuplicatingLog(log, reportLog));
        }
        finally {
            life.shutdown();
            reportLogProvider.close();
        }
        if (!summary.isConsistent()) {
            log.warn("See '%s' for a detailed consistency report.", new Object[]{reportFile});
            return Result.failure(reportFile, summary);
        }
        return Result.success(reportFile, summary);
    }

    private void assertRecovered(DatabaseLayout databaseLayout, Config config, FileSystemAbstraction fileSystem, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        try {
            if (Recovery.isRecoveryRequired((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout, (Config)config, (MemoryTracker)memoryTracker)) {
                throw new IllegalStateException(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database.", "To perform recovery please start database in single mode and perform clean shutdown."}));
            }
        }
        catch (Exception e) {
            throw new ConsistencyCheckIncompleteException(e);
        }
    }

    private Path chooseReportPath(Path reportDir) {
        return reportDir.resolve(ConsistencyCheckService.defaultLogFileName(this.timestamp));
    }

    private static Path defaultReportDir(Config tuningConfiguration) {
        return (Path)tuningConfiguration.get(GraphDatabaseSettings.logs_directory);
    }

    private static String defaultLogFileName(Date date) {
        return String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date));
    }

    public static int defaultConsistencyCheckThreadsNumber() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static class CountsManager
    extends LifecycleAdapter
    implements ThrowingSupplier<CountsStore, IOException> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fileSystem;
        private final DatabaseLayout databaseLayout;
        private final PageCacheTracer pageCacheTracer;
        private final MemoryTracker memoryTracker;
        private GBPTreeCountsStore counts;

        CountsManager(PageCache pageCache, FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
            this.pageCache = pageCache;
            this.fileSystem = fileSystem;
            this.databaseLayout = databaseLayout;
            this.pageCacheTracer = pageCacheTracer;
            this.memoryTracker = memoryTracker;
        }

        public CountsStore get() throws IOException {
            this.counts = new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.ignore(), (CountsBuilder)new RebuildPreventingCountsInitializer(), true, this.pageCacheTracer, GBPTreeCountsStore.NO_MONITOR);
            this.counts.start(PageCursorTracer.NULL, this.memoryTracker);
            return this.counts;
        }

        public void shutdown() {
            if (this.counts != null) {
                this.counts.close();
            }
        }
    }

    private static class RebuildPreventingCountsInitializer
    implements CountsBuilder {
        private RebuildPreventingCountsInitializer() {
        }

        public void initialize(CountsAccessor.Updater updater, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
            throw new UnsupportedOperationException("Counts store needed rebuild, consistency checker will instead report broken or missing counts store");
        }

        public long lastCommittedTxId() {
            return 0L;
        }
    }

    public static class Result {
        private final boolean successful;
        private final Path reportFile;
        private final ConsistencySummaryStatistics summary;

        public static Result failure(Path reportFile, ConsistencySummaryStatistics summary) {
            return new Result(false, reportFile, summary);
        }

        public static Result success(Path reportFile, ConsistencySummaryStatistics summary) {
            return new Result(true, reportFile, summary);
        }

        private Result(boolean successful, Path reportFile, ConsistencySummaryStatistics summary) {
            this.successful = successful;
            this.reportFile = reportFile;
            this.summary = summary;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public Path reportFile() {
            return this.reportFile;
        }

        public ConsistencySummaryStatistics summary() {
            return this.summary;
        }
    }
}

