/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.LookupFilter;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyAndNodeIndexedCheck
implements RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
    private final IndexAccessors indexes;
    private final PropertyReader propertyReader;
    private final CacheAccess cacheAccess;

    PropertyAndNodeIndexedCheck(IndexAccessors indexes, PropertyReader propertyReader, CacheAccess cacheAccess) {
        this.indexes = indexes;
        this.propertyReader = propertyReader;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public void check(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        try {
            Collection<PropertyRecord> properties = this.propertyReader.getPropertyRecordChain(record.getNextProp(), cursorTracer);
            this.cacheAccess.client().putPropertiesToCache(properties);
            if (this.indexes != null) {
                this.matchIndexesToNode(record, engine, records, properties, cursorTracer);
            }
            this.checkProperty(record, engine, properties);
        }
        catch (PropertyReader.CircularPropertyRecordChainException e) {
            engine.report().propertyChainContainsCircularReference(e.propertyRecordClosingTheCircle());
        }
    }

    private void matchIndexesToNode(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, Collection<PropertyRecord> propertyRecs, PageCursorTracer cursorTracer) {
        long[] labels = NodeLabelReader.getListOfLabels(record, records, engine, cursorTracer).stream().mapToLong(Long::longValue).toArray();
        IntObjectMap<PropertyBlock> nodePropertyMap = null;
        for (IndexDescriptor indexRule : this.indexes.onlineRules()) {
            SchemaDescriptor schema = indexRule.schema();
            if (schema.entityType() != EntityType.NODE || !schema.isAffected(labels)) continue;
            if (nodePropertyMap == null) {
                nodePropertyMap = PropertyAndNodeIndexedCheck.properties(propertyRecs);
            }
            if (!PropertyAndNodeIndexedCheck.entityIntersectsSchema(nodePropertyMap, schema)) continue;
            Value[] values = PropertyAndNodeIndexedCheck.getPropertyValues(this.propertyReader, nodePropertyMap, schema.getPropertyIds(), cursorTracer);
            IndexReader reader = this.indexes.accessorFor(indexRule).newReader();
            try {
                long nodeId = record.getId();
                if (indexRule.isUnique()) {
                    this.verifyNodeCorrectlyIndexedUniquely(nodeId, values, engine, indexRule, reader, cursorTracer);
                    continue;
                }
                long count = reader.countIndexedNodes(nodeId, cursorTracer, schema.getPropertyIds(), values);
                this.reportIncorrectIndexCount(values, engine, indexRule, count);
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    private void verifyNodeCorrectlyIndexedUniquely(long nodeId, Value[] propertyValues, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, IndexDescriptor descriptor, IndexReader reader, PageCursorTracer cursorTracer) {
        IndexQuery[] query = this.seek(descriptor.schema(), propertyValues);
        try (PrimitiveLongResourceIterator indexedNodeIds = this.queryIndexOrEmpty(reader, query, cursorTracer);){
            long count = 0L;
            while (indexedNodeIds.hasNext()) {
                long indexedNodeId = indexedNodeIds.next();
                if (nodeId == indexedNodeId) {
                    ++count;
                    continue;
                }
                engine.report().uniqueIndexNotUnique(descriptor, Values.asObjects((Value[])propertyValues), indexedNodeId);
            }
            this.reportIncorrectIndexCount(propertyValues, engine, descriptor, count);
        }
    }

    private void reportIncorrectIndexCount(Value[] propertyValues, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, IndexDescriptor indexRule, long count) {
        if (count == 0L) {
            engine.report().notIndexed(indexRule, Values.asObjects((Value[])propertyValues));
        } else if (count != 1L) {
            engine.report().indexedMultipleTimes(indexRule, Values.asObjects((Value[])propertyValues), count);
        }
    }

    private void checkProperty(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, Collection<PropertyRecord> props) {
        if (!Record.NO_NEXT_PROPERTY.is(record.getNextProp())) {
            PropertyRecord firstProp = props.iterator().next();
            if (!Record.NO_PREVIOUS_PROPERTY.is(firstProp.getPrevProp())) {
                engine.report().propertyNotFirstInChain(firstProp);
            }
            IntHashSet keys = new IntHashSet();
            for (PropertyRecord property : props) {
                if (!property.inUse()) {
                    engine.report().propertyNotInUse(property);
                    continue;
                }
                for (int key : ChainCheck.keys(property)) {
                    if (keys.add(key)) continue;
                    engine.report().propertyKeyNotUniqueInChain();
                }
            }
        }
    }

    static Value[] getPropertyValues(PropertyReader propertyReader, IntObjectMap<PropertyBlock> propertyMap, int[] indexPropertyIds, PageCursorTracer cursorTracer) {
        Value[] values = new Value[indexPropertyIds.length];
        for (int i = 0; i < indexPropertyIds.length; ++i) {
            PropertyBlock propertyBlock = (PropertyBlock)propertyMap.get(indexPropertyIds[i]);
            values[i] = propertyBlock != null ? propertyReader.propertyValue(propertyBlock, cursorTracer) : NoValue.NO_VALUE;
        }
        return values;
    }

    static IntObjectMap<PropertyBlock> properties(Collection<PropertyRecord> records) {
        IntObjectHashMap propertyIds = new IntObjectHashMap();
        for (PropertyRecord record : records) {
            for (PropertyBlock propertyBlock : record) {
                propertyIds.put(propertyBlock.getKeyIndexId(), (Object)propertyBlock);
            }
        }
        return propertyIds;
    }

    private IndexQuery[] seek(SchemaDescriptor schema, Value[] propertyValues) {
        int[] propertyIds = schema.getPropertyIds();
        assert (propertyIds.length == propertyValues.length);
        IndexQuery[] query = new IndexQuery[propertyValues.length];
        for (int i = 0; i < query.length; ++i) {
            query[i] = IndexQuery.exact((int)propertyIds[i], (Object)propertyValues[i]);
        }
        return query;
    }

    private PrimitiveLongResourceIterator queryIndexOrEmpty(IndexReader reader, IndexQuery[] query, PageCursorTracer cursorTracer) {
        NodeValueIterator indexedNodeIds;
        try {
            NodeValueIterator iterator = new NodeValueIterator();
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)iterator, IndexQueryConstraints.unconstrained(), query);
            indexedNodeIds = iterator;
        }
        catch (IndexNotApplicableKernelException e) {
            throw new RuntimeException(String.format("Consistency checking error: index provider does not support exact query %s", Arrays.toString(query)), e);
        }
        if (reader.hasFullValuePrecision(query)) {
            return indexedNodeIds;
        }
        final LongIterator filtered = LookupFilter.exactIndexMatches((NodePropertyAccessor)this.propertyReader, (LongIterator)indexedNodeIds, (PageCursorTracer)cursorTracer, (IndexQuery[])query);
        return new PrimitiveLongResourceCollections.AbstractPrimitiveLongBaseResourceIterator((Resource)indexedNodeIds){

            protected boolean fetchNext() {
                return filtered.hasNext() && this.next(filtered.next());
            }
        };
    }

    static boolean entityIntersectsSchema(IntObjectMap<PropertyBlock> entityPropertyMap, SchemaDescriptor schema) {
        boolean requireAllTokens;
        boolean bl = requireAllTokens = schema.propertySchemaType() == PropertySchemaType.COMPLETE_ALL_TOKENS;
        if (requireAllTokens) {
            return PropertyAndNodeIndexedCheck.hasAllProperties(entityPropertyMap, schema.getPropertyIds());
        }
        return PropertyAndNodeIndexedCheck.hasAnyProperty(entityPropertyMap, schema.getPropertyIds());
    }

    private static boolean hasAllProperties(IntObjectMap<PropertyBlock> blockMap, int[] indexPropertyIds) {
        for (int indexPropertyId : indexPropertyIds) {
            if (blockMap.containsKey(indexPropertyId)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAnyProperty(IntObjectMap<PropertyBlock> blockMap, int[] indexPropertyIds) {
        for (int indexPropertyId : indexPropertyIds) {
            if (!blockMap.containsKey(indexPropertyId)) continue;
            return true;
        }
        return false;
    }
}

