/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.labelscan;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.RelationshipInUseWithCorrectRelationshipTypeCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.synthetic.TokenScanDocument;
import org.neo4j.internal.index.label.EntityTokenRange;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class RelationshipTypeScanCheck
implements RecordCheck<TokenScanDocument, ConsistencyReport.RelationshipTypeScanConsistencyReport> {
    @Override
    public void check(TokenScanDocument record, CheckerEngine<TokenScanDocument, ConsistencyReport.RelationshipTypeScanConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        EntityTokenRange range = record.getEntityTokenRange();
        for (long relationshipId : range.entities()) {
            long[] types = range.tokens(relationshipId);
            engine.comparativeCheck(records.relationship(relationshipId, cursorTracer), new RelationshipInUseWithCorrectRelationshipTypeCheck(types, PropertySchemaType.COMPLETE_ALL_TOKENS, true));
        }
    }
}

