/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public enum DynamicStore {
    STRING(RecordType.STRING_PROPERTY){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block, PageCursorTracer cursorTracer) {
            return records.string(block, cursorTracer);
        }
    }
    ,
    ARRAY(RecordType.ARRAY_PROPERTY){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block, PageCursorTracer cursorTracer) {
            return records.array(block, cursorTracer);
        }
    }
    ,
    PROPERTY_KEY(RecordType.PROPERTY_KEY_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block, PageCursorTracer cursorTracer) {
            return records.propertyKeyName((int)block, cursorTracer);
        }
    }
    ,
    RELATIONSHIP_TYPE(RecordType.RELATIONSHIP_TYPE_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block, PageCursorTracer cursorTracer) {
            return records.relationshipTypeName((int)block, cursorTracer);
        }
    }
    ,
    LABEL(RecordType.LABEL_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block, PageCursorTracer cursorTracer) {
            return records.labelName((int)block, cursorTracer);
        }
    }
    ,
    NODE_LABEL(RecordType.NODE_DYNAMIC_LABEL){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block, PageCursorTracer cursorTracer) {
            return records.nodeLabels(block, cursorTracer);
        }
    };

    public final RecordType type;

    private DynamicStore(RecordType type) {
        this.type = type;
    }

    abstract RecordReference<DynamicRecord> lookup(RecordAccess var1, long var2, PageCursorTracer var4);
}

