/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.util.Iterator;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexAccessor;

public class IndexIterator
implements BoundedIterable<Long> {
    private static final String CONSISTENCY_INDEX_ITERATOR_TAG = "consistencyIndexIterator";
    private static final String CONSISTENCY_INDEX_COUNTER_TAG = "consistencyIndexCounter";
    private final IndexAccessor indexAccessor;
    private final PageCacheTracer pageCacheTracer;
    private BoundedIterable<Long> indexReader;
    private PageCursorTracer readerTracer;

    public IndexIterator(IndexAccessor indexAccessor, PageCacheTracer pageCacheTracer) {
        this.indexAccessor = indexAccessor;
        this.pageCacheTracer = pageCacheTracer;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long maxCount() {
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(CONSISTENCY_INDEX_COUNTER_TAG);){
            long l;
            block14: {
                BoundedIterable reader = this.indexAccessor.newAllEntriesReader(cursorTracer);
                try {
                    l = reader.maxCount();
                    if (reader == null) break block14;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws Exception {
        if (this.indexReader != null) {
            this.indexReader.close();
            this.readerTracer.close();
        }
    }

    public Iterator<Long> iterator() {
        if (this.indexReader == null) {
            this.readerTracer = this.pageCacheTracer.createPageCursorTracer(CONSISTENCY_INDEX_ITERATOR_TAG);
            this.indexReader = this.indexAccessor.newAllEntriesReader(this.readerTracer);
        }
        return this.indexReader.iterator();
    }
}

