/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.function.BiFunction;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.PropertyRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.MandatoryProperties;
import org.neo4j.consistency.checking.full.PropertyAndNodeIndexedCheck;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public class PropertyAndNode2LabelIndexProcessor
extends RecordProcessor.Adapter<NodeRecord> {
    private final ConsistencyReporter reporter;
    private final RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> nodeIndexCheck;
    private final RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> propertyCheck;
    private final CacheAccess cacheAccess;
    private final BiFunction<NodeRecord, PageCursorTracer, MandatoryProperties.Check<NodeRecord, ConsistencyReport.NodeConsistencyReport>> mandatoryProperties;

    public PropertyAndNode2LabelIndexProcessor(ConsistencyReporter reporter, IndexAccessors indexes, PropertyReader propertyReader, CacheAccess cacheAccess, BiFunction<NodeRecord, PageCursorTracer, MandatoryProperties.Check<NodeRecord, ConsistencyReport.NodeConsistencyReport>> mandatoryProperties) {
        this.reporter = reporter;
        this.cacheAccess = cacheAccess;
        this.mandatoryProperties = mandatoryProperties;
        this.nodeIndexCheck = new PropertyAndNodeIndexedCheck(indexes, propertyReader, cacheAccess);
        this.propertyCheck = new PropertyRecordCheck();
    }

    @Override
    public void process(NodeRecord nodeRecord, PageCursorTracer cursorTracer) {
        this.reporter.forNode(nodeRecord, this.nodeIndexCheck, cursorTracer);
        CacheAccess.Client client = this.cacheAccess.client();
        try (MandatoryProperties.Check<NodeRecord, ConsistencyReport.NodeConsistencyReport> mandatoryCheck = this.mandatoryProperties.apply(nodeRecord, cursorTracer);){
            Iterable<PropertyRecord> properties = client.getPropertiesFromCache();
            if (properties != null) {
                for (PropertyRecord property : properties) {
                    this.reporter.forProperty(property, this.propertyCheck, cursorTracer);
                    mandatoryCheck.receive(ChainCheck.keys(property));
                }
            }
        }
    }
}

