/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeDynamicLabelOrphanChainStartCheck
implements RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport>,
ComparativeRecordChecker<DynamicRecord, DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> {
    private static final ComparativeRecordChecker<DynamicRecord, NodeRecord, ConsistencyReport.DynamicLabelConsistencyReport> VALID_NODE_RECORD = (record, nodeRecord, engine, records, cursorTracer) -> {
        if (!nodeRecord.inUse()) {
            ((ConsistencyReport.DynamicLabelConsistencyReport)engine.report()).orphanDynamicLabelRecordDueToInvalidOwner((NodeRecord)nodeRecord);
        } else {
            long dynamicLabelRecordId;
            long recordId = record.getId();
            if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)nodeRecord.getLabelField()) && (dynamicLabelRecordId = NodeLabelsField.firstDynamicLabelRecordId((long)nodeRecord.getLabelField())) != recordId) {
                ((ConsistencyReport.DynamicLabelConsistencyReport)engine.report()).orphanDynamicLabelRecordDueToInvalidOwner((NodeRecord)nodeRecord);
            }
        }
    };

    @Override
    public void check(DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        if (record.inUse() && record.isStartRecord()) {
            Long ownerId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)record);
            if (null == ownerId) {
                engine.report().orphanDynamicLabelRecord();
            } else {
                engine.comparativeCheck(records.node(ownerId, cursorTracer), VALID_NODE_RECORD);
            }
        }
    }

    @Override
    public void checkReference(DynamicRecord record, DynamicRecord record2, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
    }
}

