/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyCheckTasks;
import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.CountsBuilderDecorator;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.OwnerCheck;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.TaskExecutor;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.newchecker.RecordStorageConsistencyChecker;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.store.CacheSmallStoresRecordAccess;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.logging.Log;

public class FullCheck {
    private final boolean useExperimentalChecker;
    private final Config config;
    private final boolean verbose;
    private final NodeBasedMemoryLimiter.Factory memoryLimit;
    private final ProgressMonitorFactory progressFactory;
    private final ConsistencyFlags flags;
    private final IndexSamplingConfig samplingConfig;
    private final int threads;
    private final Statistics statistics;

    public FullCheck(ProgressMonitorFactory progressFactory, Statistics statistics, int threads, ConsistencyFlags consistencyFlags, Config config, boolean verbose, NodeBasedMemoryLimiter.Factory memoryLimit) {
        this.statistics = statistics;
        this.threads = threads;
        this.progressFactory = progressFactory;
        this.flags = consistencyFlags;
        this.samplingConfig = new IndexSamplingConfig(config);
        this.config = config;
        this.useExperimentalChecker = (Boolean)config.get(GraphDatabaseSettings.experimental_consistency_checker);
        this.verbose = verbose;
        this.memoryLimit = memoryLimit;
    }

    public ConsistencySummaryStatistics execute(PageCache pageCache, DirectStoreAccess stores, ThrowingSupplier<CountsStore, IOException> countsSupplier, Log log) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
        InconsistencyReport report = new InconsistencyReport(new InconsistencyMessageLogger(log), summary);
        CountsStore countsStore = this.getCountsStore(countsSupplier, log, summary);
        this.execute(pageCache, stores, report, countsStore);
        if (!summary.isConsistent()) {
            log.warn("Inconsistencies found: " + summary);
        }
        return summary;
    }

    private void checkCountsStoreConsistency(InconsistencyReport report, CountsBuilderDecorator countsBuilder, RecordAccess records, CountsStore countsStore) {
        if (this.flags.isCheckGraph() && countsStore != CountsStore.nullInstance) {
            countsBuilder.checkCounts((CountsAccessor)countsStore, new ConsistencyReporter(records, report), this.progressFactory);
        }
    }

    private CountsStore getCountsStore(ThrowingSupplier<CountsStore, IOException> countsSupplier, Log log, ConsistencySummaryStatistics summary) {
        CountsStore countsStore = CountsStore.nullInstance;
        if (this.flags.isCheckGraph() || this.flags.isCheckIndexStructure()) {
            try {
                countsStore = (CountsStore)countsSupplier.get();
            }
            catch (Exception e) {
                log.error("Counts store is missing, broken or of an older format and will not be consistency checked", (Throwable)e);
                summary.update(RecordType.COUNTS, 1, 0);
            }
        }
        return countsStore;
    }

    void execute(PageCache pageCache, DirectStoreAccess directStoreAccess, InconsistencyReport report, CountsStore countsStore) throws ConsistencyCheckIncompleteException {
        block14: {
            try (IndexAccessors indexes = new IndexAccessors(directStoreAccess.indexes(), directStoreAccess.nativeStores().getRawNeoStores(), this.samplingConfig);){
                if (this.flags.isCheckIndexStructure()) {
                    FullCheck.consistencyCheckIndexStructure(directStoreAccess.labelScanStore(), directStoreAccess.indexStatisticsStore(), countsStore, indexes, this.allIdGenerators(directStoreAccess), report, this.progressFactory);
                }
                if (!this.useExperimentalChecker) {
                    DefaultCacheAccess cacheAccess = new DefaultCacheAccess(DefaultCacheAccess.defaultByteArray(directStoreAccess.nativeStores().getNodeStore().getHighId()), this.statistics.getCounts(), this.threads);
                    RecordAccess recordAccess = FullCheck.recordAccess(directStoreAccess.nativeStores(), cacheAccess);
                    OwnerCheck ownerCheck = new OwnerCheck(this.flags.isCheckPropertyOwners(), new DynamicStore[0]);
                    CountsBuilderDecorator countsBuilder = new CountsBuilderDecorator(directStoreAccess.nativeStores());
                    CheckDecorator.ChainCheckDecorator decorator = new CheckDecorator.ChainCheckDecorator(ownerCheck, countsBuilder);
                    ConsistencyReporter reporter = new ConsistencyReporter(recordAccess, report, ConsistencyReporter.NO_MONITOR);
                    StoreAccess nativeStores = directStoreAccess.nativeStores();
                    StoreProcessor processEverything = new StoreProcessor(decorator, reporter, Stage.SEQUENTIAL_FORWARD, cacheAccess);
                    ProgressMonitorFactory.MultiPartBuilder progress = this.progressFactory.multipleParts("Full Consistency Check");
                    MultiPassStore.Factory multiPass = new MultiPassStore.Factory(decorator, recordAccess, cacheAccess, report, ConsistencyReporter.NO_MONITOR);
                    ConsistencyCheckTasks taskCreator = new ConsistencyCheckTasks(progress, processEverything, nativeStores, this.statistics, cacheAccess, directStoreAccess.labelScanStore(), indexes, multiPass, reporter, this.threads);
                    List<ConsistencyCheckerTask> tasks = taskCreator.createTasksForFullCheck(this.flags.isCheckLabelScanStore(), this.flags.isCheckIndexes(), this.flags.isCheckGraph());
                    progress.build();
                    TaskExecutor.execute(tasks, decorator::prepare);
                    this.checkCountsStoreConsistency(report, countsBuilder, recordAccess, countsStore);
                    ownerCheck.scanForOrphanChains(this.progressFactory);
                    break block14;
                }
                try (RecordStorageConsistencyChecker checker = new RecordStorageConsistencyChecker(pageCache, directStoreAccess.nativeStores().getRawNeoStores(), countsStore, directStoreAccess.labelScanStore(), indexes, report, this.progressFactory, this.config, this.threads, this.verbose, this.flags, this.memoryLimit);){
                    checker.check();
                }
            }
            catch (Exception e) {
                throw new ConsistencyCheckIncompleteException(e);
            }
        }
    }

    private List<IdGenerator> allIdGenerators(DirectStoreAccess directStoreAccess) {
        ArrayList<IdGenerator> idGenerators = new ArrayList<IdGenerator>();
        directStoreAccess.idGeneratorFactory().visit(idGenerators::add);
        return idGenerators;
    }

    private static RecordAccess recordAccess(StoreAccess store, CacheAccess cacheAccess) {
        return new CacheSmallStoresRecordAccess(new DirectRecordAccess(store, cacheAccess), (PropertyKeyTokenRecord[])FullCheck.readAllRecords(PropertyKeyTokenRecord.class, (RecordStore)store.getPropertyKeyTokenStore()), (RelationshipTypeTokenRecord[])FullCheck.readAllRecords(RelationshipTypeTokenRecord.class, (RecordStore)store.getRelationshipTypeTokenStore()), (LabelTokenRecord[])FullCheck.readAllRecords(LabelTokenRecord.class, (RecordStore)store.getLabelTokenStore()));
    }

    private static void consistencyCheckIndexStructure(LabelScanStore labelScanStore, IndexStatisticsStore indexStatisticsStore, CountsStore countsStore, IndexAccessors indexes, List<IdGenerator> idGenerators, InconsistencyReport report, ProgressMonitorFactory progressMonitorFactory) {
        long schemaIndexCount = Iterables.count(indexes.onlineRules());
        long additionalCount = 3L;
        long idGeneratorsCount = idGenerators.size();
        long totalCount = schemaIndexCount + 3L + idGeneratorsCount;
        ProgressListener listener = progressMonitorFactory.singlePart("Index structure consistency check", totalCount);
        listener.started();
        FullCheck.consistencyCheckNonSchemaIndexes(report, listener, labelScanStore, indexStatisticsStore, countsStore, idGenerators);
        FullCheck.consistencyCheckSchemaIndexes(indexes, report, listener);
        listener.done();
    }

    private static void consistencyCheckNonSchemaIndexes(InconsistencyReport report, ProgressListener listener, LabelScanStore labelScanStore, IndexStatisticsStore indexStatisticsStore, CountsStore countsStore, List<IdGenerator> idGenerators) {
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)labelScanStore, RecordType.LABEL_SCAN_DOCUMENT);
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)indexStatisticsStore, RecordType.INDEX_STATISTICS);
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)countsStore, RecordType.COUNTS);
        for (IdGenerator idGenerator : idGenerators) {
            FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)idGenerator, RecordType.ID_STORE);
        }
    }

    private static void consistencyCheckSingleCheckable(InconsistencyReport report, ProgressListener listener, ConsistencyCheckable checkable, RecordType recordType) {
        ConsistencyReporter.FormattingDocumentedHandler handler = ConsistencyReporter.formattingHandler(report, recordType);
        ReporterFactory proxyFactory = new ReporterFactory((InvocationHandler)handler);
        checkable.consistencyCheck(proxyFactory);
        handler.updateSummary();
        listener.add(1L);
    }

    private static void consistencyCheckSchemaIndexes(IndexAccessors indexes, InconsistencyReport report, ProgressListener listener) {
        ArrayList<IndexDescriptor> rulesToRemove = new ArrayList<IndexDescriptor>();
        for (IndexDescriptor onlineRule : indexes.onlineRules()) {
            ConsistencyReporter.FormattingDocumentedHandler handler = ConsistencyReporter.formattingHandler(report, RecordType.INDEX);
            ReporterFactory reporterFactory = new ReporterFactory((InvocationHandler)handler);
            IndexAccessor accessor = indexes.accessorFor(onlineRule);
            if (!accessor.consistencyCheck(reporterFactory)) {
                rulesToRemove.add(onlineRule);
            }
            handler.updateSummary();
            listener.add(1L);
        }
        for (IndexDescriptor toRemove : rulesToRemove) {
            indexes.remove(toRemove);
        }
    }

    private static <T extends AbstractBaseRecord> T[] readAllRecords(Class<T> type, RecordStore<T> store) {
        AbstractBaseRecord[] records = (AbstractBaseRecord[])Array.newInstance(type, (int)store.getHighId());
        for (int i = 0; i < records.length; ++i) {
            records[i] = store.getRecord((long)i, store.newRecord(), RecordLoad.FORCE);
        }
        return records;
    }
}

