/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.annotations.documented.DocumentedUtils;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.consistency.store.synthetic.CountsEntry;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.consistency.store.synthetic.LabelScanDocument;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;

public class ConsistencyReporter
implements ConsistencyReport.Reporter {
    private static final ProxyFactory<ConsistencyReport.SchemaConsistencyReport> SCHEMA_REPORT = ProxyFactory.create(ConsistencyReport.SchemaConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.NodeConsistencyReport> NODE_REPORT = ProxyFactory.create(ConsistencyReport.NodeConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipConsistencyReport> RELATIONSHIP_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.PropertyConsistencyReport> PROPERTY_REPORT = ProxyFactory.create(ConsistencyReport.PropertyConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipTypeConsistencyReport> RELATIONSHIP_TYPE_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipTypeConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.LabelTokenConsistencyReport> LABEL_KEY_REPORT = ProxyFactory.create(ConsistencyReport.LabelTokenConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.PropertyKeyTokenConsistencyReport> PROPERTY_KEY_REPORT = ProxyFactory.create(ConsistencyReport.PropertyKeyTokenConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.DynamicConsistencyReport> DYNAMIC_REPORT = ProxyFactory.create(ConsistencyReport.DynamicConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.DynamicLabelConsistencyReport> DYNAMIC_LABEL_REPORT = ProxyFactory.create(ConsistencyReport.DynamicLabelConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.LabelScanConsistencyReport> LABEL_SCAN_REPORT = ProxyFactory.create(ConsistencyReport.LabelScanConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.IndexConsistencyReport> INDEX_REPORT = ProxyFactory.create(ConsistencyReport.IndexConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipGroupConsistencyReport> RELATIONSHIP_GROUP_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipGroupConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.CountsConsistencyReport> COUNTS_REPORT = ProxyFactory.create(ConsistencyReport.CountsConsistencyReport.class);
    private final RecordAccess records;
    private final InconsistencyReport report;
    private final Monitor monitor;
    public static final Monitor NO_MONITOR = (report, method, message) -> {};

    public ConsistencyReporter(RecordAccess records, InconsistencyReport report) {
        this(records, report, NO_MONITOR);
    }

    public ConsistencyReporter(RecordAccess records, InconsistencyReport report, Monitor monitor) {
        this.records = records;
        this.report = report;
        this.monitor = monitor;
    }

    private <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> void dispatch(RecordType type, ProxyFactory<REPORT> factory, RECORD record, RecordCheck<RECORD, REPORT> checker) {
        ReportHandler handler = new ReportHandler(this.report, factory, type, this.records, record, this.monitor);
        try {
            checker.check(record, handler, this.records);
        }
        catch (Exception e) {
            handler.report.error(type, record, "Failed to check record: " + Exceptions.stringify((Throwable)e), new Object[0]);
        }
    }

    static void dispatchReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord referenced, RecordAccess records) {
        ReportInvocationHandler handler = (ReportInvocationHandler)engine;
        handler.checkReference(engine, checker, referenced, records);
    }

    static String pendingCheckToString(CheckerEngine engine, ComparativeRecordChecker checker) {
        ReportInvocationHandler handler = (ReportInvocationHandler)engine;
        return handler.pendingCheckToString(checker);
    }

    static void dispatchChangeReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord oldReferenced, AbstractBaseRecord newReferenced, RecordAccess records) {
        ReportInvocationHandler handler = (ReportInvocationHandler)engine;
        handler.checkDiffReference(engine, checker, oldReferenced, newReferenced, records);
    }

    static void dispatchSkip(CheckerEngine engine) {
    }

    @Override
    public <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> REPORT report(RECORD record, Class<REPORT> cls, RecordType recordType) {
        ProxyFactory<REPORT> proxyFactory = ProxyFactory.get(cls);
        ReportHandler handler = new ReportHandler<RECORD, REPORT>(this.report, proxyFactory, recordType, this.records, record, this.monitor){

            @Override
            protected void inconsistencyReported() {
            }
        };
        return handler.report();
    }

    public static FormattingDocumentedHandler formattingHandler(InconsistencyReport report, RecordType type) {
        return new FormattingDocumentedHandler(report, type);
    }

    @Override
    public void forSchema(SchemaRecord schema, RecordCheck<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> checker) {
        this.dispatch(RecordType.SCHEMA, SCHEMA_REPORT, schema, checker);
    }

    @Override
    public void forNode(NodeRecord node, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.dispatch(RecordType.NODE, NODE_REPORT, node, checker);
    }

    @Override
    public void forRelationship(RelationshipRecord relationship, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.dispatch(RecordType.RELATIONSHIP, RELATIONSHIP_REPORT, relationship, checker);
    }

    @Override
    public void forProperty(PropertyRecord property, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.dispatch(RecordType.PROPERTY, PROPERTY_REPORT, property, checker);
    }

    @Override
    public void forRelationshipTypeName(RelationshipTypeTokenRecord relationshipTypeTokenRecord, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
        this.dispatch(RecordType.RELATIONSHIP_TYPE, RELATIONSHIP_TYPE_REPORT, relationshipTypeTokenRecord, checker);
    }

    @Override
    public void forLabelName(LabelTokenRecord label, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
        this.dispatch(RecordType.LABEL, LABEL_KEY_REPORT, label, checker);
    }

    @Override
    public void forNodeLabelScan(LabelScanDocument document, RecordCheck<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> checker) {
        this.dispatch(RecordType.LABEL_SCAN_DOCUMENT, LABEL_SCAN_REPORT, document, checker);
    }

    @Override
    public void forIndexEntry(IndexEntry entry, RecordCheck<IndexEntry, ConsistencyReport.IndexConsistencyReport> checker) {
        this.dispatch(RecordType.INDEX, INDEX_REPORT, entry, checker);
    }

    @Override
    public void forPropertyKey(PropertyKeyTokenRecord key, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
        this.dispatch(RecordType.PROPERTY_KEY, PROPERTY_KEY_REPORT, key, checker);
    }

    @Override
    public void forDynamicBlock(RecordType type, DynamicRecord record, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.dispatch(type, DYNAMIC_REPORT, record, checker);
    }

    @Override
    public void forDynamicLabelBlock(RecordType type, DynamicRecord record, RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> checker) {
        this.dispatch(type, DYNAMIC_LABEL_REPORT, record, checker);
    }

    @Override
    public void forRelationshipGroup(RelationshipGroupRecord record, RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> checker) {
        this.dispatch(RecordType.RELATIONSHIP_GROUP, RELATIONSHIP_GROUP_REPORT, record, checker);
    }

    @Override
    public void forCounts(CountsEntry countsEntry, RecordCheck<CountsEntry, ConsistencyReport.CountsConsistencyReport> checker) {
        this.dispatch(RecordType.COUNTS, COUNTS_REPORT, countsEntry, checker);
    }

    @Override
    public ConsistencyReport.SchemaConsistencyReport forSchema(SchemaRecord schema) {
        return this.report(SCHEMA_REPORT, RecordType.SCHEMA, schema);
    }

    @Override
    public ConsistencyReport.NodeConsistencyReport forNode(NodeRecord node) {
        return this.report(NODE_REPORT, RecordType.NODE, node);
    }

    @Override
    public ConsistencyReport.RelationshipConsistencyReport forRelationship(RelationshipRecord relationship) {
        return this.report(RELATIONSHIP_REPORT, RecordType.RELATIONSHIP, relationship);
    }

    @Override
    public ConsistencyReport.PropertyConsistencyReport forProperty(PropertyRecord property) {
        return this.report(PROPERTY_REPORT, RecordType.PROPERTY, property);
    }

    @Override
    public ConsistencyReport.RelationshipTypeConsistencyReport forRelationshipTypeName(RelationshipTypeTokenRecord relationshipType) {
        return this.report(RELATIONSHIP_TYPE_REPORT, RecordType.RELATIONSHIP_TYPE, relationshipType);
    }

    @Override
    public ConsistencyReport.LabelTokenConsistencyReport forLabelName(LabelTokenRecord label) {
        return this.report(LABEL_KEY_REPORT, RecordType.LABEL, label);
    }

    @Override
    public ConsistencyReport.PropertyKeyTokenConsistencyReport forPropertyKey(PropertyKeyTokenRecord key) {
        return this.report(PROPERTY_KEY_REPORT, RecordType.PROPERTY_KEY, key);
    }

    @Override
    public ConsistencyReport.DynamicConsistencyReport forDynamicBlock(RecordType type, DynamicRecord record) {
        return this.report(DYNAMIC_REPORT, type, record);
    }

    @Override
    public ConsistencyReport.DynamicLabelConsistencyReport forDynamicLabelBlock(RecordType type, DynamicRecord record) {
        return this.report(DYNAMIC_LABEL_REPORT, type, record);
    }

    @Override
    public ConsistencyReport.LabelScanConsistencyReport forNodeLabelScan(LabelScanDocument document) {
        return this.report(LABEL_SCAN_REPORT, RecordType.LABEL_SCAN_DOCUMENT, document);
    }

    @Override
    public ConsistencyReport.IndexConsistencyReport forIndexEntry(IndexEntry entry) {
        return this.report(INDEX_REPORT, RecordType.INDEX, entry);
    }

    @Override
    public ConsistencyReport.RelationshipGroupConsistencyReport forRelationshipGroup(RelationshipGroupRecord group) {
        return this.report(RELATIONSHIP_GROUP_REPORT, RecordType.RELATIONSHIP_GROUP, group);
    }

    @Override
    public ConsistencyReport.CountsConsistencyReport forCounts(CountsEntry countsEntry) {
        return this.report(COUNTS_REPORT, RecordType.COUNTS, countsEntry);
    }

    private <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> REPORT report(ProxyFactory<REPORT> factory, RecordType type, RECORD record) {
        return new ReportHandler(this.report, factory, type, this.records, record, this.monitor).report();
    }

    public static class ProxyFactory<T> {
        private static final Map<Class<?>, ProxyFactory<?>> INSTANCES = new HashMap();
        private Constructor<? extends T> constructor;
        private final Class<T> type;

        static <T> ProxyFactory<T> get(Class<T> cls) {
            return INSTANCES.get(cls);
        }

        ProxyFactory(Class<T> type) throws LinkageError {
            this.type = type;
            try {
                this.constructor = Proxy.getProxyClass(ConsistencyReporter.class.getClassLoader(), type).getConstructor(InvocationHandler.class);
                INSTANCES.put(type, this);
            }
            catch (NoSuchMethodException e) {
                throw new LinkageError("Cannot access Proxy constructor for " + type.getName(), e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + Arrays.asList(this.constructor.getDeclaringClass().getInterfaces());
        }

        Class<?> type() {
            return this.type;
        }

        public T create(InvocationHandler handler) {
            try {
                return this.constructor.newInstance(handler);
            }
            catch (Exception e) {
                throw new LinkageError("Failed to create proxy instance", e);
            }
        }

        public static <T> ProxyFactory<T> create(Class<T> type) {
            return new ProxyFactory<T>(type);
        }
    }

    public static class ReportHandler<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport>
    extends ReportInvocationHandler<RECORD, REPORT> {
        private final AbstractBaseRecord record;

        public ReportHandler(InconsistencyReport report, ProxyFactory<REPORT> factory, RecordType type, RecordAccess records, AbstractBaseRecord record, Monitor monitor) {
            super(report, factory, type, records, monitor);
            this.record = record;
        }

        @Override
        long recordId() {
            return this.record.getId();
        }

        @Override
        protected void logError(String message, Object[] args) {
            this.report.error(this.type, this.record, message, args);
        }

        @Override
        protected void logWarning(String message, Object[] args) {
            this.report.warning(this.type, this.record, message, args);
        }

        @Override
        void checkReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord referenced, RecordAccess records) {
            checker.checkReference(this.record, referenced, this, records);
        }

        @Override
        void checkDiffReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord oldReferenced, AbstractBaseRecord newReferenced, RecordAccess records) {
            checker.checkReference(this.record, newReferenced, this, records);
        }
    }

    public static abstract class ReportInvocationHandler<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport>
    implements CheckerEngine<RECORD, REPORT>,
    InvocationHandler {
        final InconsistencyReport report;
        private final ProxyFactory<REPORT> factory;
        final RecordType type;
        private short references = 1;
        private final RecordAccess records;
        private final Monitor monitor;

        private ReportInvocationHandler(InconsistencyReport report, ProxyFactory<REPORT> factory, RecordType type, RecordAccess records, Monitor monitor) {
            this.report = report;
            this.factory = factory;
            this.type = type;
            this.records = records;
            this.monitor = monitor;
        }

        String pendingCheckToString(ComparativeRecordChecker checker) {
            String checkName;
            try {
                if (checker.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                    checkName = checker.getClass().getSimpleName();
                    if (checkName.isEmpty()) {
                        checkName = checker.getClass().getName();
                    }
                } else {
                    checkName = checker.toString();
                }
            }
            catch (NoSuchMethodException e) {
                checkName = checker.toString();
            }
            return String.format("ReferenceCheck{%s[%s]/%s}", new Object[]{this.type, this.recordId(), checkName});
        }

        abstract long recordId();

        @Override
        public <REFERRED extends AbstractBaseRecord> void comparativeCheck(RecordReference<REFERRED> reference, ComparativeRecordChecker<RECORD, ? super REFERRED, REPORT> checker) {
            this.references = (short)(this.references + 1);
            reference.dispatch(new PendingReferenceCheck(this, checker));
        }

        @Override
        public REPORT report() {
            return (REPORT)((ConsistencyReport)this.factory.create(this));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String message = DocumentedUtils.extractMessage((Method)method);
            if (method.getAnnotation(ConsistencyReport.Warning.class) == null) {
                args = this.getRealRecords(args);
                this.logError(message, args);
                this.report.updateSummary(this.type, 1, 0);
            } else {
                args = this.getRealRecords(args);
                this.logWarning(message, args);
                this.report.updateSummary(this.type, 0, 1);
            }
            this.monitor.reported(this.factory.type(), method.getName(), message);
            this.inconsistencyReported();
            return null;
        }

        protected void inconsistencyReported() {
        }

        private Object[] getRealRecords(Object[] args) {
            if (args == null) {
                return args;
            }
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof AbstractBaseRecord) || !((AbstractBaseRecord)args[i]).isCreated()) continue;
                if (args[i] instanceof NodeRecord) {
                    args[i] = ((DirectRecordReference)this.records.node(((NodeRecord)args[i]).getId())).record();
                    continue;
                }
                if (!(args[i] instanceof RelationshipRecord)) continue;
                args[i] = ((DirectRecordReference)this.records.relationship(((RelationshipRecord)args[i]).getId())).record();
            }
            return args;
        }

        protected abstract void logError(String var1, Object[] var2);

        protected abstract void logWarning(String var1, Object[] var2);

        abstract void checkReference(CheckerEngine var1, ComparativeRecordChecker var2, AbstractBaseRecord var3, RecordAccess var4);

        abstract void checkDiffReference(CheckerEngine var1, ComparativeRecordChecker var2, AbstractBaseRecord var3, AbstractBaseRecord var4, RecordAccess var5);
    }

    public static class FormattingDocumentedHandler
    implements InvocationHandler {
        private final InconsistencyReport report;
        private final RecordType type;
        private short errors;
        private short warnings;

        FormattingDocumentedHandler(InconsistencyReport report, RecordType type) {
            this.report = report;
            this.type = type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String message = DocumentedUtils.extractFormattedMessage((Method)method, (Object[])args);
            if (method.getAnnotation(ConsistencyReport.Warning.class) == null) {
                this.errors = (short)(this.errors + 1);
                this.report.error(message);
            } else {
                this.warnings = (short)(this.warnings + 1);
                this.report.warning(message);
            }
            return null;
        }

        public void updateSummary() {
            this.report.updateSummary(this.type, this.errors, this.warnings);
        }
    }

    public static interface Monitor {
        public void reported(Class<?> var1, String var2, String var3);
    }
}

