/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyReportLog;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.internal.SchemaIndexExtensionLoader;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.AccessStatsKeepingStoreAccess;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.statistics.VerboseStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.function.Suppliers;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.NativeLabelScanStore;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class ConsistencyCheckService {
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Deprecated
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, tuningConfiguration, progressFactory, logProvider, verbose, ConsistencyFlags.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        try {
            Result result = this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, (FileSystemAbstraction)fileSystem, verbose, consistencyFlags);
            return result;
        }
        finally {
            try {
                fileSystem.close();
            }
            catch (IOException e) {
                Log log = logProvider.getLog(this.getClass());
                log.error("Failure during shutdown of file system", (Throwable)e);
            }
        }
    }

    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, verbose, ConsistencyCheckService.defaultReportDir(config), consistencyFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, File reportDir, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        Log log = logProvider.getLog(this.getClass());
        JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, logProvider.getLog(PageCache.class), EmptyVersionContextSupplier.EMPTY, jobScheduler);
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            Result result = this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, pageCache, verbose, reportDir, consistencyFlags);
            return result;
        }
        finally {
            try {
                pageCache.close();
            }
            catch (Exception e) {
                log.error("Failure during shutdown of the page cache", (Throwable)e);
            }
            try {
                jobScheduler.close();
            }
            catch (Exception e) {
                log.error("Failure during shutdown of the job scheduler", (Throwable)e);
            }
        }
    }

    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, pageCache, verbose, ConsistencyCheckService.defaultReportDir(config), consistencyFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, File reportDir, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        this.assertRecovered(databaseLayout, config, fileSystem);
        Log log = logProvider.getLog(this.getClass());
        config.set(GraphDatabaseSettings.read_only, (Object)true);
        config.set(GraphDatabaseSettings.pagecache_warmup_enabled, (Object)false);
        LifeSupport life = new LifeSupport();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate());
        StoreFactory factory = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fileSystem, logProvider);
        CountsManager countsManager = new CountsManager(pageCache, fileSystem, databaseLayout);
        life.add((Lifecycle)countsManager);
        File reportFile = this.chooseReportPath(reportDir);
        Suppliers.Lazy<PrintWriter> reportWriterSupplier = ConsistencyCheckService.getReportWriterSupplier(fileSystem, reportFile);
        ConsistencyReportLog reportLog = new ConsistencyReportLog((Supplier<PrintWriter>)reportWriterSupplier);
        Monitors monitors = new Monitors();
        JobScheduler jobScheduler = (JobScheduler)life.add((Lifecycle)JobSchedulerFactory.createInitialisedScheduler());
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "Label"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "RelationshipType"));
        RecoveryCleanupWorkCollector workCollector = RecoveryCleanupWorkCollector.ignore();
        DatabaseExtensions extensions = (DatabaseExtensions)life.add((Lifecycle)SchemaIndexExtensionLoader.instantiateExtensions(databaseLayout, fileSystem, config, (LogService)new SimpleLogService(logProvider, logProvider), pageCache, jobScheduler, workCollector, DatabaseInfo.TOOL, monitors, tokenHolders));
        DefaultIndexProviderMap indexes = (DefaultIndexProviderMap)life.add((Lifecycle)new DefaultIndexProviderMap((DependencyResolver)extensions, config));
        try (NeoStores neoStores = factory.openAllNeoStores();){
            StoreAccess storeAccess;
            Statistics statistics;
            tokenHolders.setInitialTokens(StoreTokens.allReadableTokens((NeoStores)neoStores));
            life.start();
            NativeLabelScanStore labelScanStore = new NativeLabelScanStore(pageCache, databaseLayout, fileSystem, FullStoreChangeStream.EMPTY, true, monitors, workCollector);
            life.add((Lifecycle)labelScanStore);
            IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(pageCache, databaseLayout, workCollector, true);
            life.add((Lifecycle)indexStatisticsStore);
            int numberOfThreads = ConsistencyCheckService.defaultConsistencyCheckThreadsNumber();
            AccessStatistics stats = new AccessStatistics();
            if (verbose) {
                statistics = new VerboseStatistics(stats, new DefaultCounts(numberOfThreads), log);
                storeAccess = new AccessStatsKeepingStoreAccess(neoStores, stats);
            } else {
                statistics = Statistics.NONE;
                storeAccess = new StoreAccess(neoStores);
            }
            storeAccess.initialize();
            DirectStoreAccess stores = new DirectStoreAccess(storeAccess, (LabelScanStore)labelScanStore, (IndexProviderMap)indexes, tokenHolders, indexStatisticsStore, (IdGeneratorFactory)idGeneratorFactory);
            FullCheck check = new FullCheck(progressFactory, statistics, numberOfThreads, consistencyFlags, config, verbose, NodeBasedMemoryLimiter.DEFAULT);
            summary = check.execute(pageCache, stores, countsManager, (Log)new DuplicatingLog(new Log[]{log, reportLog}));
        }
        finally {
            life.shutdown();
            if (reportWriterSupplier.isInitialised()) {
                ((PrintWriter)reportWriterSupplier.get()).close();
            }
        }
        if (!summary.isConsistent()) {
            log.warn("See '%s' for a detailed consistency report.", new Object[]{reportFile.getPath()});
            return Result.failure(reportFile, summary);
        }
        return Result.success(reportFile, summary);
    }

    private void assertRecovered(DatabaseLayout databaseLayout, Config config, FileSystemAbstraction fileSystem) throws ConsistencyCheckIncompleteException {
        try {
            if (Recovery.isRecoveryRequired((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout, (Config)config)) {
                throw new IllegalStateException(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database.", "To perform recovery please start database in single mode and perform clean shutdown."}));
            }
        }
        catch (Exception e) {
            throw new ConsistencyCheckIncompleteException(e);
        }
    }

    private static Suppliers.Lazy<PrintWriter> getReportWriterSupplier(FileSystemAbstraction fileSystem, File reportFile) {
        return Suppliers.lazySingleton(() -> {
            try {
                return new PrintWriter(FileSystemUtils.createOrOpenAsOutputStream((FileSystemAbstraction)fileSystem, (File)reportFile, (boolean)true));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private File chooseReportPath(File reportDir) {
        return new File(reportDir, ConsistencyCheckService.defaultLogFileName(this.timestamp));
    }

    private static File defaultReportDir(Config tuningConfiguration) {
        return ((Path)tuningConfiguration.get(GraphDatabaseSettings.logs_directory)).toFile();
    }

    private static String defaultLogFileName(Date date) {
        return String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date));
    }

    public static int defaultConsistencyCheckThreadsNumber() {
        return Runtime.getRuntime().availableProcessors();
    }

    private class CountsManager
    extends LifecycleAdapter
    implements ThrowingSupplier<CountsStore, IOException> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fileSystem;
        private final DatabaseLayout databaseLayout;
        private GBPTreeCountsStore counts;

        CountsManager(PageCache pageCache, FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
            this.pageCache = pageCache;
            this.fileSystem = fileSystem;
            this.databaseLayout = databaseLayout;
        }

        public CountsStore get() throws IOException {
            this.counts = new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.ignore(), (CountsBuilder)new RebuildPreventingCountsInitializer(), true, GBPTreeCountsStore.NO_MONITOR);
            this.counts.start();
            return this.counts;
        }

        public void shutdown() {
            if (this.counts != null) {
                this.counts.close();
            }
        }
    }

    private class RebuildPreventingCountsInitializer
    implements CountsBuilder {
        private RebuildPreventingCountsInitializer() {
        }

        public void initialize(CountsAccessor.Updater updater) {
            throw new UnsupportedOperationException("Counts store needed rebuild, consistency checker will instead report broken or missing counts store");
        }

        public long lastCommittedTxId() {
            return 0L;
        }
    }

    public static class Result {
        private final boolean successful;
        private final File reportFile;
        private final ConsistencySummaryStatistics summary;

        public static Result failure(File reportFile, ConsistencySummaryStatistics summary) {
            return new Result(false, reportFile, summary);
        }

        public static Result success(File reportFile, ConsistencySummaryStatistics summary) {
            return new Result(true, reportFile, summary);
        }

        private Result(boolean successful, File reportFile, ConsistencySummaryStatistics summary) {
            this.successful = successful;
            this.reportFile = reportFile;
            this.summary = summary;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public File reportFile() {
            return this.reportFile;
        }

        public ConsistencySummaryStatistics summary() {
            return this.summary;
        }
    }
}

