/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.neo4j.consistency.checking.ByteArrayBitsManipulator;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.kernel.impl.store.record.Record;

class PackedMultiFieldCache {
    private final ByteArray array;
    private ByteArrayBitsManipulator slots;
    private long[] initValues;

    PackedMultiFieldCache(ByteArray array, int ... slotSizes) {
        this.array = array;
        this.setSlotSizes(slotSizes);
    }

    void put(long index, long ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.slots.set(this.array, index, i, values[i]);
        }
    }

    void put(long index, int slot, long value) {
        this.slots.set(this.array, index, slot, value);
    }

    long get(long index, int slot) {
        if (index < this.array.length()) {
            return this.slots.get(this.array, index, slot);
        }
        return this.initValues[slot];
    }

    void setSlotSizes(int ... slotSizes) {
        this.slots = new ByteArrayBitsManipulator(slotSizes);
        this.initValues = PackedMultiFieldCache.getInitVals(slotSizes);
    }

    void clear() {
        long length = this.array.length();
        for (long i = 0L; i < length; ++i) {
            this.clear(i);
        }
    }

    void clear(long index) {
        this.put(index, this.initValues);
    }

    private static long[] getInitVals(int[] slotSizes) {
        long[] initVals = new long[slotSizes.length];
        for (int i = 0; i < initVals.length; ++i) {
            initVals[i] = PackedMultiFieldCache.isId(slotSizes, i) ? (long)Record.NO_NEXT_RELATIONSHIP.intValue() : 0L;
        }
        return initVals;
    }

    private static boolean isId(int[] slotSizes, int i) {
        return slotSizes[i] >= 40;
    }
}

