/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.Arrays;
import java.util.function.Function;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.RecordLoading;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.LookupFilter;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.transaction.state.storeview.DefaultNodePropertyAccessor;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SchemaComplianceChecker
implements AutoCloseable {
    private final IntObjectMap<MutableIntSet> mandatoryProperties;
    private final MutableIntSet reportedMissingMandatoryPropertyKeys = new IntHashSet();
    private final IndexAccessors.IndexReaders indexReaders;
    private final Iterable<IndexDescriptor> indexes;
    private final DefaultNodePropertyAccessor propertyAccessor;

    SchemaComplianceChecker(CheckerContext context, MutableIntObjectMap<MutableIntSet> mandatoryProperties, Iterable<IndexDescriptor> indexes) {
        this.mandatoryProperties = mandatoryProperties;
        this.indexReaders = context.indexAccessors.readers();
        this.indexes = indexes;
        this.propertyAccessor = new DefaultNodePropertyAccessor((StorageReader)new RecordStorageReader(context.neoStores));
    }

    <ENTITY extends PrimitiveRecord> void checkContainsMandatoryProperties(ENTITY entity, long[] entityTokens, IntObjectMap<Value> values, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reportSupplier) {
        if (entityTokens.length > 0) {
            this.checkMandatoryProperties(entity, values, entityTokens, reportSupplier);
        }
    }

    <ENTITY extends PrimitiveRecord> void checkCorrectlyIndexed(ENTITY entity, long[] entityTokens, IntObjectMap<Value> values, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reportSupplier) {
        for (IndexDescriptor indexRule : this.indexes) {
            SchemaDescriptor schema = indexRule.schema();
            Value[] valueArray = RecordLoading.entityIntersectionWithSchema(entityTokens, values, schema);
            if (valueArray == null) continue;
            IndexReader reader = this.indexReaders.reader(indexRule);
            if (indexRule.isUnique()) {
                this.verifyIndexedUniquely(entity, valueArray, indexRule, reader, reportSupplier);
                continue;
            }
            long count = reader.countIndexedNodes(entity.getId(), schema.getPropertyIds(), valueArray);
            this.reportIncorrectIndexCount(entity, valueArray, indexRule, count, reportSupplier);
        }
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.indexReaders, this.propertyAccessor});
    }

    private <ENTITY extends PrimitiveRecord> void verifyIndexedUniquely(ENTITY entity, Value[] propertyValues, IndexDescriptor indexRule, IndexReader reader, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reportSupplier) {
        long nodeId = entity.getId();
        IndexQuery[] query = this.seek(indexRule.schema(), propertyValues);
        LongIterator indexedNodeIds = this.queryIndexOrEmpty(reader, query);
        long count = 0L;
        while (indexedNodeIds.hasNext()) {
            long indexedNodeId = indexedNodeIds.next();
            if (nodeId == indexedNodeId) {
                ++count;
                continue;
            }
            reportSupplier.apply(entity).uniqueIndexNotUnique(indexRule, Values.asObjects((Value[])propertyValues), indexedNodeId);
        }
        this.reportIncorrectIndexCount(entity, propertyValues, indexRule, count, reportSupplier);
    }

    private IndexQuery[] seek(SchemaDescriptor schema, Value[] propertyValues) {
        int[] propertyIds = schema.getPropertyIds();
        assert (propertyIds.length == propertyValues.length);
        IndexQuery[] query = new IndexQuery[propertyValues.length];
        for (int i = 0; i < query.length; ++i) {
            query[i] = IndexQuery.exact((int)propertyIds[i], (Object)propertyValues[i]);
        }
        return query;
    }

    private LongIterator queryIndexOrEmpty(IndexReader reader, IndexQuery[] query) {
        NodeValueIterator indexedNodeIds;
        try {
            NodeValueIterator iterator = new NodeValueIterator();
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)iterator, IndexOrder.NONE, false, query);
            indexedNodeIds = iterator;
        }
        catch (IndexNotApplicableKernelException e) {
            throw new RuntimeException(String.format("Consistency checking error: index provider does not support exact query %s", Arrays.toString(query)), e);
        }
        return reader.hasFullValuePrecision(query) ? indexedNodeIds : LookupFilter.exactIndexMatches((NodePropertyAccessor)this.propertyAccessor, (LongIterator)indexedNodeIds, (IndexQuery[])query);
    }

    private <ENTITY extends PrimitiveRecord> void reportIncorrectIndexCount(ENTITY entity, Value[] propertyValues, IndexDescriptor indexRule, long count, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reportSupplier) {
        if (count == 0L) {
            reportSupplier.apply(entity).notIndexed(indexRule, Values.asObjects((Value[])propertyValues));
        } else if (count != 1L) {
            reportSupplier.apply(entity).indexedMultipleTimes(indexRule, Values.asObjects((Value[])propertyValues), count);
        }
    }

    private <ENTITY extends PrimitiveRecord> void checkMandatoryProperties(ENTITY entity, IntObjectMap<Value> seenProperties, long[] entityTokenIds, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reporter) {
        if (!this.mandatoryProperties.isEmpty()) {
            RecordLoading.lightClear((MutableIntCollection)this.reportedMissingMandatoryPropertyKeys);
            for (long entityToken : entityTokenIds) {
                MutableIntSet mandatoryPropertyKeysForEntityToken = (MutableIntSet)this.mandatoryProperties.get(Math.toIntExact(entityToken));
                if (mandatoryPropertyKeysForEntityToken == null) continue;
                MutableIntIterator iterator = mandatoryPropertyKeysForEntityToken.intIterator();
                while (iterator.hasNext()) {
                    int mandatoryPropertyKeyForEntityToken = iterator.next();
                    if (seenProperties.containsKey(mandatoryPropertyKeyForEntityToken) || !this.reportedMissingMandatoryPropertyKeys.add(mandatoryPropertyKeyForEntityToken)) continue;
                    reporter.apply(entity).missingMandatoryProperty(mandatoryPropertyKeyForEntityToken);
                }
            }
        }
    }
}

