/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.nio.file.Path;
import picocli.CommandLine;

public class ConsistencyCheckOptions {
    @CommandLine.Option(names={"--report-dir"}, paramLabel="<path>", description={"Directory where consistency report will be written."}, defaultValue=".")
    private Path reportDir;
    @CommandLine.Option(names={"--check-graph"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Perform consistency checks between nodes, relationships, properties, types and tokens."})
    private boolean checkGraph = true;
    @CommandLine.Option(names={"--check-indexes"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Perform consistency checks on indexes."})
    private boolean checkIndexes = true;
    @CommandLine.Option(names={"--check-index-structure"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Perform structure checks on indexes."})
    private boolean checkIndexStructure = true;
    @CommandLine.Option(names={"--check-label-scan-store"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Perform consistency checks on the label scan store."})
    private boolean checkLabelScanStore = true;
    @CommandLine.Option(names={"--check-property-owners"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Perform additional consistency checks on property ownership. This check is @|bold,red very|@ expensive in time and memory."})
    private boolean checkPropertyOwners;

    public Path getReportDir() {
        return this.reportDir;
    }

    public boolean isCheckGraph() {
        return this.checkGraph;
    }

    public boolean isCheckIndexes() {
        return this.checkIndexes;
    }

    public boolean isCheckIndexStructure() {
        return this.checkIndexStructure;
    }

    public boolean isCheckLabelScanStore() {
        return this.checkLabelScanStore;
    }

    public boolean isCheckPropertyOwners() {
        return this.checkPropertyOwners;
    }
}

