/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.eclipse.collections.api.block.procedure.primitive.ObjectLongProcedure;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.synthetic.CountsEntry;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class CountsBuilderDecorator
extends CheckDecorator.Adapter {
    private static final int WILDCARD = -1;
    private final MutableObjectLongMap<CountsKey> nodeCounts = new ObjectLongHashMap();
    private final MutableObjectLongMap<CountsKey> relationshipCounts = new ObjectLongHashMap();
    private final MultiPassAvoidanceCondition<NodeRecord> nodeCountBuildCondition;
    private final MultiPassAvoidanceCondition<RelationshipRecord> relationshipCountBuildCondition;
    private final NodeStore nodeStore;
    private final StoreAccess storeAccess;
    private final CountsEntry.CheckAdapter CHECK_NODE_COUNT = new CountsEntry.CheckAdapter(){

        @Override
        public void check(CountsEntry record, CheckerEngine<CountsEntry, ConsistencyReport.CountsConsistencyReport> engine, RecordAccess records) {
            long expectedCount = CountsBuilderDecorator.this.nodeCounts.removeKeyIfAbsent((Object)record.getCountsKey(), 0L);
            if (expectedCount != record.getCount()) {
                engine.report().inconsistentNodeCount(expectedCount);
            }
        }
    };
    private final CountsEntry.CheckAdapter CHECK_RELATIONSHIP_COUNT = new CountsEntry.CheckAdapter(){

        @Override
        public void check(CountsEntry record, CheckerEngine<CountsEntry, ConsistencyReport.CountsConsistencyReport> engine, RecordAccess records) {
            long expectedCount = CountsBuilderDecorator.this.relationshipCounts.removeKeyIfAbsent((Object)record.getCountsKey(), 0L);
            if (expectedCount != record.getCount()) {
                engine.report().inconsistentRelationshipCount(expectedCount);
            }
        }
    };

    CountsBuilderDecorator(StoreAccess storeAccess) {
        this.storeAccess = storeAccess;
        this.nodeStore = storeAccess.getRawNeoStores().getNodeStore();
        this.nodeCountBuildCondition = new MultiPassAvoidanceCondition(0);
        this.relationshipCountBuildCondition = new MultiPassAvoidanceCondition(1);
    }

    @Override
    public void prepare() {
        this.nodeCountBuildCondition.prepare();
        this.relationshipCountBuildCondition.prepare();
    }

    @Override
    public OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> decorateNodeChecker(OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        return new NodeCounts((RecordStore<NodeRecord>)this.nodeStore, this.nodeCounts, this.nodeCountBuildCondition, checker);
    }

    @Override
    public OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> decorateRelationshipChecker(OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        return new RelationshipCounts(this.storeAccess, this.relationshipCounts, this.relationshipCountBuildCondition, checker);
    }

    public void checkCounts(CountsAccessor counts, final ConsistencyReporter reporter, ProgressMonitorFactory progressFactory) {
        int nodes = this.nodeCounts.size();
        int relationships = this.relationshipCounts.size();
        int total = nodes + relationships;
        final AtomicInteger nodeEntries = new AtomicInteger(0);
        final AtomicInteger relationshipEntries = new AtomicInteger(0);
        final ProgressListener listener = progressFactory.singlePart("Checking node and relationship counts", (long)total);
        listener.started();
        counts.accept((CountsVisitor)new CountsVisitor.Adapter(){

            public void visitNodeCount(int labelId, long count) {
                nodeEntries.incrementAndGet();
                reporter.forCounts(new CountsEntry(CountsKey.nodeKey((long)labelId), count), CountsBuilderDecorator.this.CHECK_NODE_COUNT);
                listener.add(1L);
            }

            public void visitRelationshipCount(int startLabelId, int relTypeId, int endLabelId, long count) {
                relationshipEntries.incrementAndGet();
                reporter.forCounts(new CountsEntry(CountsKey.relationshipKey((long)startLabelId, (long)relTypeId, (long)endLabelId), count), CountsBuilderDecorator.this.CHECK_RELATIONSHIP_COUNT);
                listener.add(1L);
            }
        });
        this.nodeCounts.forEachKeyValue((ObjectLongProcedure & Serializable)(key, count) -> reporter.forCounts(new CountsEntry((CountsKey)key, 0L), this.CHECK_NODE_COUNT));
        this.relationshipCounts.forEachKeyValue((ObjectLongProcedure & Serializable)(key, count) -> reporter.forCounts(new CountsEntry((CountsKey)key, 0L), this.CHECK_RELATIONSHIP_COUNT));
        listener.done();
    }

    private static Set<Long> labelsFor(RecordStore<NodeRecord> nodeStore, CheckerEngine<? extends AbstractBaseRecord, ? extends ConsistencyReport> engine, RecordAccess recordAccess, long nodeId) {
        return NodeLabelReader.getListOfLabels((NodeRecord)nodeStore.getRecord(nodeId, (AbstractBaseRecord)((NodeRecord)nodeStore.newRecord()), RecordLoad.FORCE), recordAccess, engine);
    }

    private static class MultiPassAvoidanceCondition<T extends AbstractBaseRecord>
    implements Predicate<T> {
        private final int activeStage;
        private volatile int stage = -1;

        MultiPassAvoidanceCondition(int activeStage) {
            this.activeStage = activeStage;
        }

        public void prepare() {
            ++this.stage;
        }

        @Override
        public boolean test(T record) {
            return this.stage == this.activeStage;
        }
    }

    private static class RelationshipCounts
    implements OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> {
        private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
        private final NodeStore nodeStore;
        private final MutableObjectLongMap<CountsKey> counts;
        private final Predicate<RelationshipRecord> countUpdateCondition;
        private final OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> inner;

        RelationshipCounts(StoreAccess storeAccess, MutableObjectLongMap<CountsKey> counts, Predicate<RelationshipRecord> countUpdateCondition, OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> inner) {
            this.nodeStore = storeAccess.getRawNeoStores().getNodeStore();
            this.counts = counts;
            this.countUpdateCondition = countUpdateCondition;
            this.inner = inner;
        }

        @Override
        public ComparativeRecordChecker<RelationshipRecord, PrimitiveRecord, ConsistencyReport.RelationshipConsistencyReport> ownerCheck() {
            return this.inner.ownerCheck();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void check(RelationshipRecord record, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
            if (this.countUpdateCondition.test(record) && record.inUse()) {
                CacheAccess.Client cacheAccess = records.cacheAccess().client();
                long firstLabelsField = cacheAccess.getFromCache(record.getFirstNode(), 0);
                Set<Long> firstNodeLabels = NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)firstLabelsField) ? CountsBuilderDecorator.labelsFor((RecordStore<NodeRecord>)this.nodeStore, engine, records, record.getFirstNode()) : NodeLabelReader.getListOfLabels(firstLabelsField);
                long secondLabelsField = cacheAccess.getFromCache(record.getSecondNode(), 0);
                Set<Long> secondNodeLabels = NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)secondLabelsField) ? CountsBuilderDecorator.labelsFor((RecordStore<NodeRecord>)this.nodeStore, engine, records, record.getSecondNode()) : NodeLabelReader.getListOfLabels(secondLabelsField);
                int type = record.getType();
                MutableObjectLongMap<CountsKey> mutableObjectLongMap = this.counts;
                synchronized (mutableObjectLongMap) {
                    this.counts.addToValue((Object)CountsKey.relationshipKey((long)-1L, (long)-1L, (long)-1L), 1L);
                    this.counts.addToValue((Object)CountsKey.relationshipKey((long)-1L, (long)type, (long)-1L), 1L);
                    if (firstNodeLabels != null) {
                        for (long firstLabel : firstNodeLabels) {
                            this.counts.addToValue((Object)CountsKey.relationshipKey((long)((int)firstLabel), (long)-1L, (long)-1L), 1L);
                            this.counts.addToValue((Object)CountsKey.relationshipKey((long)((int)firstLabel), (long)type, (long)-1L), 1L);
                        }
                    }
                    if (secondNodeLabels != null) {
                        for (long secondLabel : secondNodeLabels) {
                            this.counts.addToValue((Object)CountsKey.relationshipKey((long)-1L, (long)-1L, (long)((int)secondLabel)), 1L);
                            this.counts.addToValue((Object)CountsKey.relationshipKey((long)-1L, (long)type, (long)((int)secondLabel)), 1L);
                        }
                    }
                }
            }
            this.inner.check(record, engine, records);
        }
    }

    private static class NodeCounts
    implements OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
        private final RecordStore<NodeRecord> nodeStore;
        private final MutableObjectLongMap<CountsKey> counts;
        private final Predicate<NodeRecord> countUpdateCondition;
        private final OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> inner;

        NodeCounts(RecordStore<NodeRecord> nodeStore, MutableObjectLongMap<CountsKey> counts, Predicate<NodeRecord> countUpdateCondition, OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> inner) {
            this.nodeStore = nodeStore;
            this.counts = counts;
            this.countUpdateCondition = countUpdateCondition;
            this.inner = inner;
        }

        @Override
        public ComparativeRecordChecker<NodeRecord, PrimitiveRecord, ConsistencyReport.NodeConsistencyReport> ownerCheck() {
            return this.inner.ownerCheck();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void check(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
            if (this.countUpdateCondition.test(record) && record.inUse()) {
                CacheAccess.Client client = records.cacheAccess().client();
                client.putToCacheSingle(record.getId(), 1, 1L);
                client.putToCacheSingle(record.getId(), 0, record.getLabelField());
                Set<Long> labels = CountsBuilderDecorator.labelsFor(this.nodeStore, engine, records, record.getId());
                MutableObjectLongMap<CountsKey> mutableObjectLongMap = this.counts;
                synchronized (mutableObjectLongMap) {
                    this.counts.addToValue((Object)CountsKey.nodeKey((long)-1L), 1L);
                    for (long label : labels) {
                        this.counts.addToValue((Object)CountsKey.nodeKey((long)((int)label)), 1L);
                    }
                }
            }
            this.inner.check(record, engine, records);
        }
    }
}

