/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public enum OwnerChain implements ComparativeRecordChecker<PropertyRecord, PropertyRecord, ConsistencyReport.PropertyConsistencyReport>
{
    NEW{

        @Override
        RecordReference<PropertyRecord> property(RecordAccess records, long id) {
            return records.property(id);
        }

        @Override
        RecordReference<NodeRecord> node(RecordAccess records, long id) {
            return records.node(id);
        }

        @Override
        RecordReference<RelationshipRecord> relationship(RecordAccess records, long id) {
            return records.relationship(id);
        }

        @Override
        RecordReference<NeoStoreRecord> graph(RecordAccess records) {
            return records.graph();
        }

        @Override
        void wrongOwner(ConsistencyReport.PropertyConsistencyReport report) {
            report.ownerDoesNotReferenceBack();
        }
    };

    private final ComparativeRecordChecker<PropertyRecord, PrimitiveRecord, ConsistencyReport.PropertyConsistencyReport> OWNER_CHECK = (record, owner, engine, records) -> {
        if (!owner.inUse() && !record.inUse()) {
            return;
        }
        if (!owner.inUse() || Record.NO_NEXT_PROPERTY.is(owner.getNextProp())) {
            this.wrongOwner((ConsistencyReport.PropertyConsistencyReport)engine.report());
        } else if (owner.getNextProp() != record.getId()) {
            engine.comparativeCheck(this.property(records, owner.getNextProp()), this);
        }
    };

    @Override
    public void checkReference(PropertyRecord record, PropertyRecord property, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
        if (record.getId() != property.getId()) {
            if (!property.inUse() || Record.NO_NEXT_PROPERTY.is(property.getNextProp())) {
                this.wrongOwner(engine.report());
            } else if (property.getNextProp() != record.getId()) {
                engine.comparativeCheck(this.property(records, property.getNextProp()), this);
            }
        }
    }

    public void check(PropertyRecord record, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
        engine.comparativeCheck(this.ownerOf(record, records), this.OWNER_CHECK);
    }

    private RecordReference<? extends PrimitiveRecord> ownerOf(PropertyRecord record, RecordAccess records) {
        if (record.getNodeId() != -1L) {
            return this.node(records, record.getNodeId());
        }
        if (record.getRelId() != -1L) {
            return this.relationship(records, record.getRelId());
        }
        return this.graph(records);
    }

    abstract RecordReference<PropertyRecord> property(RecordAccess var1, long var2);

    abstract RecordReference<NodeRecord> node(RecordAccess var1, long var2);

    abstract RecordReference<RelationshipRecord> relationship(RecordAccess var1, long var2);

    abstract RecordReference<NeoStoreRecord> graph(RecordAccess var1);

    abstract void wrongOwner(ConsistencyReport.PropertyConsistencyReport var1);
}

