/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyCheckTasks;
import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.CountsBuilderDecorator;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.OwnerCheck;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.TaskExecutor;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.store.CacheSmallStoresRecordAccess;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.annotations.ReporterFactory;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class FullCheck {
    private final boolean checkPropertyOwners;
    private final boolean checkLabelScanStore;
    private final boolean checkIndexes;
    private final boolean checkIndexStructure;
    private final ProgressMonitorFactory progressFactory;
    private final IndexSamplingConfig samplingConfig;
    private final boolean checkGraph;
    private final int threads;
    private final Statistics statistics;
    private final boolean startCountsStore;

    public FullCheck(Config config, ProgressMonitorFactory progressFactory, Statistics statistics, int threads, boolean startCountsStore) {
        this(progressFactory, statistics, threads, new ConsistencyFlags(config), config, startCountsStore);
    }

    public FullCheck(ProgressMonitorFactory progressFactory, Statistics statistics, int threads, ConsistencyFlags consistencyFlags, Config config, boolean startCountsStore) {
        this.statistics = statistics;
        this.threads = threads;
        this.progressFactory = progressFactory;
        this.samplingConfig = new IndexSamplingConfig(config);
        this.checkGraph = consistencyFlags.isCheckGraph();
        this.checkIndexes = consistencyFlags.isCheckIndexes();
        this.checkIndexStructure = consistencyFlags.isCheckIndexStructure();
        this.checkLabelScanStore = consistencyFlags.isCheckLabelScanStore();
        this.checkPropertyOwners = consistencyFlags.isCheckPropertyOwners();
        this.startCountsStore = startCountsStore;
    }

    public ConsistencySummaryStatistics execute(DirectStoreAccess stores, Log log) throws ConsistencyCheckIncompleteException {
        return this.execute(stores, log, ConsistencyReporter.NO_MONITOR);
    }

    ConsistencySummaryStatistics execute(DirectStoreAccess stores, Log log, ConsistencyReporter.Monitor reportMonitor) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
        InconsistencyReport report = new InconsistencyReport(new InconsistencyMessageLogger(log), summary);
        OwnerCheck ownerCheck = new OwnerCheck(this.checkPropertyOwners, new DynamicStore[0]);
        CountsBuilderDecorator countsBuilder = new CountsBuilderDecorator(stores.nativeStores());
        CheckDecorator.ChainCheckDecorator decorator = new CheckDecorator.ChainCheckDecorator(ownerCheck, countsBuilder);
        DefaultCacheAccess cacheAccess = new DefaultCacheAccess(NumberArrayFactory.AUTO_WITHOUT_PAGECACHE.newByteArray(stores.nativeStores().getNodeStore().getHighId(), new byte[11]), this.statistics.getCounts(), this.threads);
        RecordAccess records = FullCheck.recordAccess(stores.nativeStores(), cacheAccess);
        this.execute(stores, decorator, records, report, cacheAccess, reportMonitor);
        ownerCheck.scanForOrphanChains(this.progressFactory);
        if (this.checkGraph) {
            CountsAccessor countsAccessor = stores.nativeStores().getCounts();
            boolean checkCounts = true;
            if (this.startCountsStore && countsAccessor instanceof CountsTracker) {
                CountsTracker tracker = (CountsTracker)countsAccessor;
                tracker.setInitializer((DataInitializer)new RebuildPreventingCountsInitializer());
                try {
                    tracker.start();
                }
                catch (Exception e) {
                    log.error("Counts store is missing, broken or of an older format and will not be consistency checked", (Throwable)e);
                    summary.update(RecordType.COUNTS, 1, 0);
                    checkCounts = false;
                }
            }
            if (checkCounts) {
                countsBuilder.checkCounts(countsAccessor, new ConsistencyReporter(records, report), this.progressFactory);
            }
        }
        if (!summary.isConsistent()) {
            log.warn("Inconsistencies found: " + summary);
        }
        return summary;
    }

    void execute(DirectStoreAccess directStoreAccess, CheckDecorator decorator, RecordAccess recordAccess, InconsistencyReport report, CacheAccess cacheAccess, ConsistencyReporter.Monitor reportMonitor) throws ConsistencyCheckIncompleteException {
        ConsistencyReporter reporter = new ConsistencyReporter(recordAccess, report, reportMonitor);
        StoreProcessor processEverything = new StoreProcessor(decorator, reporter, Stage.SEQUENTIAL_FORWARD, cacheAccess);
        ProgressMonitorFactory.MultiPartBuilder progress = this.progressFactory.multipleParts("Full Consistency Check");
        StoreAccess nativeStores = directStoreAccess.nativeStores();
        try (IndexAccessors indexes = new IndexAccessors(directStoreAccess.indexes(), (RecordStore<DynamicRecord>)nativeStores.getSchemaStore(), this.samplingConfig);){
            MultiPassStore.Factory multiPass = new MultiPassStore.Factory(decorator, recordAccess, cacheAccess, report, reportMonitor);
            ConsistencyCheckTasks taskCreator = new ConsistencyCheckTasks(progress, processEverything, nativeStores, this.statistics, cacheAccess, directStoreAccess.labelScanStore(), indexes, directStoreAccess.tokenHolders(), multiPass, reporter, this.threads);
            if (this.checkIndexStructure) {
                FullCheck.consistencyCheckIndexStructure(directStoreAccess.labelScanStore(), indexes, reporter, this.progressFactory);
            }
            List<ConsistencyCheckerTask> tasks = taskCreator.createTasksForFullCheck(this.checkLabelScanStore, this.checkIndexes, this.checkGraph);
            progress.build();
            TaskExecutor.execute(tasks, decorator::prepare);
        }
        catch (Exception e) {
            throw new ConsistencyCheckIncompleteException(e);
        }
    }

    static RecordAccess recordAccess(StoreAccess store, CacheAccess cacheAccess) {
        return new CacheSmallStoresRecordAccess(new DirectRecordAccess(store, cacheAccess), (PropertyKeyTokenRecord[])FullCheck.readAllRecords(PropertyKeyTokenRecord.class, (RecordStore)store.getPropertyKeyTokenStore()), (RelationshipTypeTokenRecord[])FullCheck.readAllRecords(RelationshipTypeTokenRecord.class, (RecordStore)store.getRelationshipTypeTokenStore()), (LabelTokenRecord[])FullCheck.readAllRecords(LabelTokenRecord.class, (RecordStore)store.getLabelTokenStore()));
    }

    private static void consistencyCheckIndexStructure(LabelScanStore labelScanStore, IndexAccessors indexes, ConsistencyReporter report, ProgressMonitorFactory progressMonitorFactory) {
        long schemaIndexCount = Iterables.count(indexes.onlineRules());
        long additionalCount = 1L;
        long totalCount = schemaIndexCount + 1L;
        ProgressListener listener = progressMonitorFactory.singlePart("Index structure consistency check", totalCount);
        listener.started();
        FullCheck.consistencyCheckLabelScanStore(labelScanStore, report, listener);
        FullCheck.consistencyCheckSchemaIndexes(indexes, report, listener);
        listener.done();
    }

    private static void consistencyCheckLabelScanStore(LabelScanStore labelScanStore, ConsistencyReporter report, ProgressListener listener) {
        ConsistencyReporter.FormattingDocumentedHandler handler = report.formattingHandler(RecordType.LABEL_SCAN_DOCUMENT);
        ReporterFactory proxyFactory = new ReporterFactory((InvocationHandler)handler);
        labelScanStore.consistencyCheck(proxyFactory);
        handler.updateSummary();
        listener.add(1L);
    }

    private static void consistencyCheckSchemaIndexes(IndexAccessors indexes, ConsistencyReporter report, ProgressListener listener) {
        ArrayList<StoreIndexDescriptor> rulesToRemove = new ArrayList<StoreIndexDescriptor>();
        for (StoreIndexDescriptor onlineRule : indexes.onlineRules()) {
            ConsistencyReporter.FormattingDocumentedHandler handler = report.formattingHandler(RecordType.INDEX);
            ReporterFactory reporterFactory = new ReporterFactory((InvocationHandler)handler);
            IndexAccessor accessor = indexes.accessorFor(onlineRule);
            if (!accessor.consistencyCheck(reporterFactory)) {
                rulesToRemove.add(onlineRule);
            }
            handler.updateSummary();
            listener.add(1L);
        }
        for (StoreIndexDescriptor toRemove : rulesToRemove) {
            indexes.remove(toRemove);
        }
    }

    private static <T extends AbstractBaseRecord> T[] readAllRecords(Class<T> type, RecordStore<T> store) {
        AbstractBaseRecord[] records = (AbstractBaseRecord[])Array.newInstance(type, (int)store.getHighId());
        for (int i = 0; i < records.length; ++i) {
            records[i] = store.getRecord((long)i, store.newRecord(), RecordLoad.FORCE);
        }
        return records;
    }

    private class RebuildPreventingCountsInitializer
    implements DataInitializer<CountsAccessor.Updater> {
        private RebuildPreventingCountsInitializer() {
        }

        public void initialize(CountsAccessor.Updater updater) {
            throw new UnsupportedOperationException("Counts store needed rebuild, consistency checker will instead report broken or missing counts store");
        }

        public long initialVersion() {
            return 0L;
        }
    }
}

