/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class LabelChainWalker<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport>
implements ComparativeRecordChecker<RECORD, DynamicRecord, REPORT> {
    private final Validator<RECORD, REPORT> validator;
    private final MutableLongObjectMap<DynamicRecord> recordIds = new LongObjectHashMap();
    private final List<DynamicRecord> recordList = new ArrayList<DynamicRecord>();
    private boolean allInUse = true;

    public LabelChainWalker(Validator<RECORD, REPORT> validator) {
        this.validator = validator;
    }

    @Override
    public void checkReference(RECORD record, DynamicRecord dynamicRecord, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        this.recordIds.put(dynamicRecord.getId(), (Object)dynamicRecord);
        if (dynamicRecord.inUse()) {
            this.recordList.add(dynamicRecord);
        } else {
            this.allInUse = false;
            this.validator.onRecordNotInUse(dynamicRecord, engine);
        }
        long nextBlock = dynamicRecord.getNextBlock();
        if (Record.NO_NEXT_BLOCK.is(nextBlock)) {
            if (this.allInUse) {
                this.validator.onWellFormedChain(LabelChainWalker.labelIds(this.recordList), engine, records);
            }
        } else {
            DynamicRecord nextRecord = (DynamicRecord)this.recordIds.get(nextBlock);
            if (nextRecord != null) {
                this.validator.onRecordChainCycle(nextRecord, engine);
            } else {
                engine.comparativeCheck(records.nodeLabels(nextBlock), this);
            }
        }
    }

    public static long[] labelIds(List<DynamicRecord> recordList) {
        long[] idArray = (long[])DynamicArrayStore.getRightArray((Pair)AbstractDynamicStore.readFullByteArrayFromHeavyRecords(recordList, (PropertyType)PropertyType.ARRAY)).asObject();
        return LabelIdArray.stripNodeId((long[])idArray);
    }

    public static interface Validator<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> {
        public void onRecordNotInUse(DynamicRecord var1, CheckerEngine<RECORD, REPORT> var2);

        public void onRecordChainCycle(DynamicRecord var1, CheckerEngine<RECORD, REPORT> var2);

        public void onWellFormedChain(long[] var1, CheckerEngine<RECORD, REPORT> var2, RecordAccess var3);
    }
}

