/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.NodeRecordCheck;
import org.neo4j.consistency.checking.PropertyChain;
import org.neo4j.consistency.checking.RelationshipRecordCheck;
import org.neo4j.consistency.checking.SchemaRecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.CacheTask;
import org.neo4j.consistency.checking.full.CheckStage;
import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.GapFreeAllEntriesLabelScanReader;
import org.neo4j.consistency.checking.full.IndexCheck;
import org.neo4j.consistency.checking.full.IterableStore;
import org.neo4j.consistency.checking.full.MandatoryProperties;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.ParallelRecordScanner;
import org.neo4j.consistency.checking.full.PropertyAndNode2LabelIndexProcessor;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.full.RecordScanner;
import org.neo4j.consistency.checking.full.RelationshipIndexProcessor;
import org.neo4j.consistency.checking.full.SchemaStoreProcessorTask;
import org.neo4j.consistency.checking.full.SequentialRecordScanner;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.StoreProcessorTask;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.checking.index.IndexEntryProcessor;
import org.neo4j.consistency.checking.index.IndexIterator;
import org.neo4j.consistency.checking.labelscan.LabelScanCheck;
import org.neo4j.consistency.checking.labelscan.LabelScanDocumentProcessor;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.store.synthetic.IndexRecord;
import org.neo4j.consistency.store.synthetic.LabelScanIndex;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.Scanner;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class ConsistencyCheckTasks {
    private final ProgressMonitorFactory.MultiPartBuilder multiPartBuilder;
    private final StoreProcessor defaultProcessor;
    private final StoreAccess nativeStores;
    private final Statistics statistics;
    private final MultiPassStore.Factory multiPass;
    private final ConsistencyReporter reporter;
    private final LabelScanStore labelScanStore;
    private final IndexAccessors indexes;
    private final CacheAccess cacheAccess;
    private final int numberOfThreads;

    ConsistencyCheckTasks(ProgressMonitorFactory.MultiPartBuilder multiPartBuilder, StoreProcessor defaultProcessor, StoreAccess nativeStores, Statistics statistics, CacheAccess cacheAccess, LabelScanStore labelScanStore, IndexAccessors indexes, MultiPassStore.Factory multiPass, ConsistencyReporter reporter, int numberOfThreads) {
        this.multiPartBuilder = multiPartBuilder;
        this.defaultProcessor = defaultProcessor;
        this.nativeStores = nativeStores;
        this.statistics = statistics;
        this.cacheAccess = cacheAccess;
        this.multiPass = multiPass;
        this.reporter = reporter;
        this.labelScanStore = labelScanStore;
        this.indexes = indexes;
        this.numberOfThreads = numberOfThreads;
    }

    public List<ConsistencyCheckerTask> createTasksForFullCheck(boolean checkLabelScanStore, boolean checkIndexes, boolean checkGraph) {
        ArrayList<ConsistencyCheckerTask> tasks = new ArrayList<ConsistencyCheckerTask>();
        if (checkGraph) {
            MandatoryProperties mandatoryProperties = new MandatoryProperties(this.nativeStores);
            StoreProcessor processor = this.multiPass.processor(CheckStage.Stage1_NS_PropsLabels, MultiPassStore.PROPERTIES);
            tasks.add(this.create(CheckStage.Stage1_NS_PropsLabels.name(), this.nativeStores.getNodeStore(), processor, QueueDistribution.ROUND_ROBIN));
            processor = this.multiPass.processor(CheckStage.Stage2_RS_Labels, MultiPassStore.LABELS);
            this.multiPass.reDecorateRelationship(processor, RelationshipRecordCheck.relationshipRecordCheckForwardPass());
            tasks.add(this.create(CheckStage.Stage2_RS_Labels.name(), this.nativeStores.getRelationshipStore(), processor, QueueDistribution.ROUND_ROBIN));
            tasks.add(new CacheTask.CacheNextRel(CheckStage.Stage3_NS_NextRel, this.cacheAccess, (ResourceIterable<NodeRecord>)Scanner.scan((RecordStore)this.nativeStores.getNodeStore(), (Predicate[])new Predicate[0])));
            processor = this.multiPass.processor(CheckStage.Stage4_RS_NextRel, MultiPassStore.NODES);
            this.multiPass.reDecorateRelationship(processor, RelationshipRecordCheck.relationshipRecordCheckBackwardPass(new PropertyChain<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>(mandatoryProperties.forRelationships(this.reporter))));
            tasks.add(this.create(CheckStage.Stage4_RS_NextRel.name(), this.nativeStores.getRelationshipStore(), processor, QueueDistribution.ROUND_ROBIN));
            this.multiPass.reDecorateNode(processor, NodeRecordCheck.toCheckNextRel(), true);
            this.multiPass.reDecorateNode(processor, NodeRecordCheck.toCheckNextRelationshipGroup(), false);
            tasks.add(new CacheTask.CheckNextRel(CheckStage.Stage5_Check_NextRel, this.cacheAccess, this.nativeStores, processor));
            processor = this.multiPass.processor(CheckStage.Stage6_RS_Forward, MultiPassStore.RELATIONSHIPS);
            this.multiPass.reDecorateRelationship(processor, RelationshipRecordCheck.relationshipRecordCheckSourceChain());
            tasks.add(this.create(CheckStage.Stage6_RS_Forward.name(), this.nativeStores.getRelationshipStore(), processor, QueueDistribution.RELATIONSHIPS));
            processor = this.multiPass.processor(CheckStage.Stage7_RS_Backward, MultiPassStore.RELATIONSHIPS);
            this.multiPass.reDecorateRelationship(processor, RelationshipRecordCheck.relationshipRecordCheckSourceChain());
            tasks.add(this.create(CheckStage.Stage7_RS_Backward.name(), this.nativeStores.getRelationshipStore(), processor, QueueDistribution.RELATIONSHIPS));
            StoreProcessor relGrpProcessor = this.multiPass.processor(Stage.PARALLEL_FORWARD, MultiPassStore.RELATIONSHIP_GROUPS);
            tasks.add(this.create("RelationshipGroupStore-RelGrp", this.nativeStores.getRelationshipGroupStore(), relGrpProcessor, QueueDistribution.ROUND_ROBIN));
            PropertyReader propertyReader = new PropertyReader(this.nativeStores);
            tasks.add(this.recordScanner(CheckStage.Stage8_PS_Props.name(), new IterableStore(this.nativeStores.getNodeStore(), true), new PropertyAndNode2LabelIndexProcessor(this.reporter, checkIndexes ? this.indexes : null, propertyReader, this.cacheAccess, mandatoryProperties.forNodes(this.reporter)), CheckStage.Stage8_PS_Props, QueueDistribution.ROUND_ROBIN, new IterableStore(this.nativeStores.getPropertyStore(), true)));
            List<StoreIndexDescriptor> relationshipIndexes = Iterables.stream(this.indexes.onlineRules()).filter(rule -> rule.schema().entityType() == EntityType.RELATIONSHIP).collect(Collectors.toList());
            if (checkIndexes && !relationshipIndexes.isEmpty()) {
                tasks.add(this.recordScanner(CheckStage.Stage9_RS_Indexes.name(), new IterableStore(this.nativeStores.getRelationshipStore(), true), new RelationshipIndexProcessor(this.reporter, this.indexes, propertyReader, relationshipIndexes), CheckStage.Stage9_RS_Indexes, QueueDistribution.ROUND_ROBIN, new IterableStore(this.nativeStores.getPropertyStore(), true)));
            }
            tasks.add(this.create("StringStore-Str", this.nativeStores.getStringStore(), this.multiPass.processor(Stage.SEQUENTIAL_FORWARD, MultiPassStore.STRINGS), QueueDistribution.ROUND_ROBIN));
            tasks.add(this.create("ArrayStore-Arrays", this.nativeStores.getArrayStore(), this.multiPass.processor(Stage.SEQUENTIAL_FORWARD, MultiPassStore.ARRAYS), QueueDistribution.ROUND_ROBIN));
        }
        tasks.add(this.create("SchemaStore", this.nativeStores.getSchemaStore(), QueueDistribution.ROUND_ROBIN));
        SchemaRecordCheck schemaCheck = new SchemaRecordCheck((SchemaRuleAccess)new SchemaStorage(this.nativeStores.getSchemaStore()), this.indexes);
        tasks.add(new SchemaStoreProcessorTask("SchemaStoreProcessor-check_rules", this.statistics, this.numberOfThreads, this.nativeStores.getSchemaStore(), this.nativeStores, "check_rules", schemaCheck, this.multiPartBuilder, this.cacheAccess, this.defaultProcessor, QueueDistribution.ROUND_ROBIN));
        tasks.add(new SchemaStoreProcessorTask("SchemaStoreProcessor-check_obligations", this.statistics, this.numberOfThreads, this.nativeStores.getSchemaStore(), this.nativeStores, "check_obligations", schemaCheck.forObligationChecking(), this.multiPartBuilder, this.cacheAccess, this.defaultProcessor, QueueDistribution.ROUND_ROBIN));
        if (checkGraph) {
            tasks.add(this.create("RelationshipTypeTokenStore", this.nativeStores.getRelationshipTypeTokenStore(), QueueDistribution.ROUND_ROBIN));
            tasks.add(this.create("PropertyKeyTokenStore", this.nativeStores.getPropertyKeyTokenStore(), QueueDistribution.ROUND_ROBIN));
            tasks.add(this.create("LabelTokenStore", this.nativeStores.getLabelTokenStore(), QueueDistribution.ROUND_ROBIN));
            tasks.add(this.create("RelationshipTypeNameStore", this.nativeStores.getRelationshipTypeNameStore(), QueueDistribution.ROUND_ROBIN));
            tasks.add(this.create("PropertyKeyNameStore", this.nativeStores.getPropertyKeyNameStore(), QueueDistribution.ROUND_ROBIN));
            tasks.add(this.create("LabelNameStore", this.nativeStores.getLabelNameStore(), QueueDistribution.ROUND_ROBIN));
            tasks.add(this.create("NodeDynamicLabelStore", this.nativeStores.getNodeDynamicLabelStore(), QueueDistribution.ROUND_ROBIN));
        }
        ConsistencyReporter filteredReporter = this.multiPass.reporter(MultiPassStore.NODES);
        if (checkLabelScanStore) {
            long highId = this.nativeStores.getNodeStore().getHighId();
            tasks.add(new LabelIndexDirtyCheckTask());
            tasks.add(this.recordScanner("LabelScanStore", (BoundedIterable)new GapFreeAllEntriesLabelScanReader(this.labelScanStore.allNodeLabelRanges(), highId), new LabelScanDocumentProcessor(filteredReporter, new LabelScanCheck()), Stage.SEQUENTIAL_FORWARD, QueueDistribution.ROUND_ROBIN, new IterableStore[0]));
        }
        if (checkIndexes) {
            tasks.add(new IndexDirtyCheckTask());
            for (StoreIndexDescriptor indexRule : this.indexes.onlineRules()) {
                tasks.add(this.recordScanner(String.format("Index_%d", indexRule.getId()), new IndexIterator(this.indexes.accessorFor(indexRule)), new IndexEntryProcessor(filteredReporter, new IndexCheck(indexRule)), Stage.SEQUENTIAL_FORWARD, QueueDistribution.ROUND_ROBIN, new IterableStore[0]));
            }
        }
        return tasks;
    }

    private <RECORD> RecordScanner<RECORD> recordScanner(String name, BoundedIterable<RECORD> store, RecordProcessor<RECORD> processor, Stage stage, QueueDistribution distribution, IterableStore ... warmupStores) {
        return stage.isParallel() ? new ParallelRecordScanner<RECORD>(name, this.statistics, this.numberOfThreads, store, this.multiPartBuilder, processor, this.cacheAccess, distribution, warmupStores) : new SequentialRecordScanner<RECORD>(name, this.statistics, this.numberOfThreads, store, this.multiPartBuilder, processor, warmupStores);
    }

    private <RECORD extends AbstractBaseRecord> StoreProcessorTask<RECORD> create(String name, RecordStore<RECORD> input, QueueDistribution distribution) {
        return new StoreProcessorTask<RECORD>(name, this.statistics, this.numberOfThreads, input, this.nativeStores, name, this.multiPartBuilder, this.cacheAccess, this.defaultProcessor, distribution);
    }

    private <RECORD extends AbstractBaseRecord> StoreProcessorTask<RECORD> create(String name, RecordStore<RECORD> input, StoreProcessor processor, QueueDistribution distribution) {
        return new StoreProcessorTask<RECORD>(name, this.statistics, this.numberOfThreads, input, this.nativeStores, name, this.multiPartBuilder, this.cacheAccess, processor, distribution);
    }

    private class IndexDirtyCheckTask
    extends ConsistencyCheckerTask {
        IndexDirtyCheckTask() {
            super("Indexes dirty check", Statistics.NONE, 1);
        }

        @Override
        public void run() {
            for (StoreIndexDescriptor indexRule : ConsistencyCheckTasks.this.indexes.onlineRules()) {
                if (!ConsistencyCheckTasks.this.indexes.accessorFor(indexRule).isDirty()) continue;
                ConsistencyCheckTasks.this.reporter.report(new IndexRecord(indexRule), ConsistencyReport.IndexConsistencyReport.class, RecordType.INDEX).dirtyIndex();
            }
        }
    }

    private class LabelIndexDirtyCheckTask
    extends ConsistencyCheckerTask {
        LabelIndexDirtyCheckTask() {
            super("Label index dirty check", Statistics.NONE, 1);
        }

        @Override
        public void run() {
            if (ConsistencyCheckTasks.this.labelScanStore instanceof NativeLabelScanStore && ((NativeLabelScanStore)ConsistencyCheckTasks.this.labelScanStore).isDirty()) {
                ConsistencyCheckTasks.this.reporter.report(new LabelScanIndex(ConsistencyCheckTasks.this.labelScanStore.getLabelScanStoreFile()), ConsistencyReport.LabelScanConsistencyReport.class, RecordType.LABEL_SCAN_DOCUMENT).dirtyIndex();
            }
        }
    }
}

