/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.PropertyAndNodeIndexedCheck;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RelationshipToIndexCheck
implements RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> {
    private final IndexAccessors indexes;
    private final StoreIndexDescriptor[] relationshipIndexes;
    private final PropertyReader propertyReader;

    RelationshipToIndexCheck(List<StoreIndexDescriptor> relationshipIndexes, IndexAccessors indexes, PropertyReader propertyReader) {
        this.relationshipIndexes = relationshipIndexes.toArray(new StoreIndexDescriptor[0]);
        this.indexes = indexes;
        this.propertyReader = propertyReader;
    }

    @Override
    public void check(RelationshipRecord record, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
        IntObjectMap<PropertyBlock> propertyMap = null;
        for (StoreIndexDescriptor index : this.relationshipIndexes) {
            SchemaDescriptor schema = index.schema();
            if (!ArrayUtils.contains((int[])schema.getEntityTokenIds(), (int)record.getType())) continue;
            if (propertyMap == null) {
                Collection<PropertyRecord> propertyRecs = this.propertyReader.getPropertyRecordChain((PrimitiveRecord)record);
                propertyMap = PropertyAndNodeIndexedCheck.properties(this.propertyReader.propertyBlocks(propertyRecs));
            }
            if (!PropertyAndNodeIndexedCheck.entityIntersectsSchema(propertyMap, schema)) continue;
            Value[] values = PropertyAndNodeIndexedCheck.getPropertyValues(this.propertyReader, propertyMap, schema.getPropertyIds());
            try (IndexReader reader = this.indexes.accessorFor(index).newReader();){
                long entityId = record.getId();
                long count = reader.countIndexedNodes(entityId, schema.getPropertyIds(), values);
                this.reportIncorrectIndexCount(values, engine, index, count);
            }
        }
    }

    private void reportIncorrectIndexCount(Value[] values, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, StoreIndexDescriptor index, long count) {
        if (count == 0L) {
            engine.report().notIndexed(index, Values.asObjects((Value[])values));
        } else if (count != 1L) {
            engine.report().indexedMultipleTimes(index, Values.asObjects((Value[])values), count);
        }
    }
}

