/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyReader
implements NodePropertyAccessor {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    PropertyReader(StoreAccess storeAccess) {
        this.propertyStore = storeAccess.getRawNeoStores().getPropertyStore();
        this.nodeStore = storeAccess.getRawNeoStores().getNodeStore();
    }

    Collection<PropertyRecord> getPropertyRecordChain(PrimitiveRecord entityRecord) {
        return this.getPropertyRecordChain(entityRecord.getNextProp());
    }

    private Collection<PropertyRecord> getPropertyRecordChain(long firstId) {
        long nextProp = firstId;
        LinkedList<PropertyRecord> toReturn = new LinkedList<PropertyRecord>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = (PropertyRecord)this.propertyStore.getRecord(nextProp, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.FORCE);
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    List<PropertyBlock> propertyBlocks(Collection<PropertyRecord> records) {
        ArrayList<PropertyBlock> propertyBlocks = new ArrayList<PropertyBlock>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record) {
                propertyBlocks.add(block);
            }
        }
        return propertyBlocks;
    }

    private List<PropertyBlock> propertyBlocks(PrimitiveRecord entityRecord) {
        Collection records = this.propertyStore.getPropertyRecordChain(entityRecord.getNextProp());
        ArrayList<PropertyBlock> propertyBlocks = new ArrayList<PropertyBlock>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record) {
                propertyBlocks.add(block);
            }
        }
        return propertyBlocks;
    }

    public Value propertyValue(PropertyBlock block) {
        return block.getType().value(block, this.propertyStore);
    }

    public Value getNodePropertyValue(long nodeId, int propertyKeyId) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        if (((NodeRecord)this.nodeStore.getRecord(nodeId, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE)).inUse()) {
            for (PropertyBlock block : this.propertyBlocks((PrimitiveRecord)nodeRecord)) {
                if (block.getKeyIndexId() != propertyKeyId) continue;
                return this.propertyValue(block);
            }
        }
        return Values.NO_VALUE;
    }
}

