/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class IndexCheck
implements RecordCheck<IndexEntry, ConsistencyReport.IndexConsistencyReport> {
    private final StoreIndexDescriptor indexRule;

    public IndexCheck(StoreIndexDescriptor indexRule) {
        this.indexRule = indexRule;
    }

    @Override
    public void check(IndexEntry record, CheckerEngine<IndexEntry, ConsistencyReport.IndexConsistencyReport> engine, RecordAccess records) {
        int[] entityTokenIds = this.indexRule.schema().getEntityTokenIds();
        engine.comparativeCheck(records.node(record.getId()), new NodeInUseWithCorrectLabelsCheck(Arrays.stream(entityTokenIds).asLongStream().toArray(), false));
    }
}

