/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public class IndexAccessors
implements Closeable {
    private final MutableLongObjectMap<IndexAccessor> accessors = new LongObjectHashMap();
    private final List<StoreIndexDescriptor> onlineIndexRules = new ArrayList<StoreIndexDescriptor>();
    private final List<StoreIndexDescriptor> notOnlineIndexRules = new ArrayList<StoreIndexDescriptor>();

    public IndexAccessors(IndexProviderMap providers, RecordStore<DynamicRecord> schemaStore, IndexSamplingConfig samplingConfig) throws IOException {
        Iterator indexes = new SchemaStorage(schemaStore).indexesGetAll();
        while (true) {
            try {
                while (indexes.hasNext()) {
                    StoreIndexDescriptor indexDescriptor = (StoreIndexDescriptor)indexes.next();
                    if (indexDescriptor.isIndexWithoutOwningConstraint()) {
                        this.notOnlineIndexRules.add(indexDescriptor);
                        continue;
                    }
                    if (InternalIndexState.ONLINE == this.provider(providers, indexDescriptor).getInitialState(indexDescriptor)) {
                        this.onlineIndexRules.add(indexDescriptor);
                        continue;
                    }
                    this.notOnlineIndexRules.add(indexDescriptor);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        for (StoreIndexDescriptor indexRule : this.onlineIndexRules) {
            long indexId = indexRule.getId();
            this.accessors.put(indexId, (Object)this.provider(providers, indexRule).getOnlineAccessor(indexRule, samplingConfig));
        }
    }

    private IndexProvider provider(IndexProviderMap providers, StoreIndexDescriptor indexRule) {
        return providers.lookup(indexRule.providerDescriptor());
    }

    public Collection<StoreIndexDescriptor> notOnlineRules() {
        return this.notOnlineIndexRules;
    }

    public IndexAccessor accessorFor(StoreIndexDescriptor indexRule) {
        return (IndexAccessor)this.accessors.get(indexRule.getId());
    }

    public Iterable<StoreIndexDescriptor> onlineRules() {
        return this.onlineIndexRules;
    }

    @Override
    public void close() throws IOException {
        for (IndexAccessor accessor : this.accessors) {
            accessor.close();
        }
        this.accessors.clear();
        this.onlineIndexRules.clear();
        this.notOnlineIndexRules.clear();
    }
}

