/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;

public class IndexAccessors
implements Closeable {
    private final Map<Long, IndexAccessor> accessors = new HashMap<Long, IndexAccessor>();
    private final List<IndexRule> onlineIndexRules = new ArrayList<IndexRule>();
    private final List<IndexRule> notOnlineIndexRules = new ArrayList<IndexRule>();

    public IndexAccessors(IndexProviderMap providers, RecordStore<DynamicRecord> schemaStore, IndexSamplingConfig samplingConfig) throws IOException {
        Iterator rules = new SchemaStorage(schemaStore).indexesGetAll();
        while (true) {
            try {
                while (rules.hasNext()) {
                    IndexRule indexRule = (IndexRule)rules.next();
                    if (InternalIndexState.ONLINE == this.provider(providers, indexRule).getInitialState(indexRule.getId(), indexRule.getIndexDescriptor())) {
                        this.onlineIndexRules.add(indexRule);
                        continue;
                    }
                    this.notOnlineIndexRules.add(indexRule);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        for (IndexRule indexRule : this.onlineIndexRules) {
            long indexId = indexRule.getId();
            this.accessors.put(indexId, this.provider(providers, indexRule).getOnlineAccessor(indexId, indexRule.getIndexDescriptor(), samplingConfig));
        }
    }

    private IndexProvider provider(IndexProviderMap providers, IndexRule indexRule) {
        return providers.apply(indexRule.getProviderDescriptor());
    }

    public Collection<IndexRule> notOnlineRules() {
        return this.notOnlineIndexRules;
    }

    public IndexAccessor accessorFor(IndexRule indexRule) {
        return this.accessors.get(indexRule.getId());
    }

    public Iterable<IndexRule> onlineRules() {
        return this.onlineIndexRules;
    }

    @Override
    public void close() throws IOException {
        for (IndexAccessor accessor : this.accessors.values()) {
            accessor.close();
        }
        this.accessors.clear();
        this.onlineIndexRules.clear();
        this.notOnlineIndexRules.clear();
    }
}

