/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import org.neo4j.consistency.ConsistencyReportLog;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.internal.SchemaIndexExtensionLoader;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.AccessStatsKeepingStoreAccess;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.statistics.VerboseStatistics;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ConsistencyCheckService {
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Deprecated
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, verbose, new ConsistencyFlags(tuningConfiguration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        try {
            Result result = this.runFullConsistencyCheck(storeDir, config, progressFactory, logProvider, (FileSystemAbstraction)fileSystem, verbose, consistencyFlags);
            return result;
        }
        finally {
            try {
                fileSystem.close();
            }
            catch (IOException e) {
                Log log = logProvider.getLog(this.getClass());
                log.error("Failure during shutdown of file system", (Throwable)e);
            }
        }
    }

    @Deprecated
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, verbose, new ConsistencyFlags(tuningConfiguration));
    }

    public Result runFullConsistencyCheck(File storeDir, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(storeDir, config, progressFactory, logProvider, fileSystem, verbose, this.defaultReportDir(config, storeDir), consistencyFlags);
    }

    @Deprecated
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, File reportDir) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, verbose, reportDir, new ConsistencyFlags(tuningConfiguration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, File reportDir, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        Log log = logProvider.getLog(this.getClass());
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, logProvider.getLog(PageCache.class), EmptyVersionContextSupplier.EMPTY);
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            Result result = this.runFullConsistencyCheck(storeDir, config, progressFactory, logProvider, fileSystem, pageCache, verbose, reportDir, consistencyFlags);
            return result;
        }
        finally {
            try {
                pageCache.close();
            }
            catch (Exception e) {
                log.error("Failure during shutdown of the page cache", (Throwable)e);
            }
        }
    }

    @Deprecated
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose, new ConsistencyFlags(tuningConfiguration));
    }

    public Result runFullConsistencyCheck(File storeDir, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(storeDir, config, progressFactory, logProvider, fileSystem, pageCache, verbose, this.defaultReportDir(config, storeDir), consistencyFlags);
    }

    @Deprecated
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, File reportDir) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose, reportDir, new ConsistencyFlags(tuningConfiguration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, File reportDir, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        Log log = logProvider.getLog(this.getClass());
        config.augment(GraphDatabaseSettings.read_only, "true");
        config.augment(GraphDatabaseSettings.pagecache_warmup_enabled, "false");
        StoreFactory factory = new StoreFactory(storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), pageCache, fileSystem, logProvider, EmptyVersionContextSupplier.EMPTY);
        File reportFile = this.chooseReportPath(reportDir);
        ConsistencyReportLog reportLog = new ConsistencyReportLog((Supplier<PrintWriter>)Suppliers.lazySingleton(() -> {
            try {
                return new PrintWriter(Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)reportFile, (boolean)true));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        Monitors monitors = new Monitors();
        LifeSupport life = new LifeSupport();
        KernelExtensions extensions = (KernelExtensions)life.add((Lifecycle)SchemaIndexExtensionLoader.instantiateKernelExtensions(storeDir, fileSystem, config, (LogService)new SimpleLogService(logProvider, logProvider), pageCache, RecoveryCleanupWorkCollector.IGNORE, DatabaseInfo.COMMUNITY, monitors));
        try (NeoStores neoStores = factory.openAllNeoStores();){
            StoreAccess storeAccess;
            Statistics statistics;
            life.start();
            IndexProviderMap indexes = SchemaIndexExtensionLoader.loadIndexProviders(extensions);
            NativeLabelScanStore labelScanStore = new NativeLabelScanStore(pageCache, storeDir, FullStoreChangeStream.EMPTY, true, monitors, RecoveryCleanupWorkCollector.IGNORE);
            life.add((Lifecycle)labelScanStore);
            int numberOfThreads = ConsistencyCheckService.defaultConsistencyCheckThreadsNumber();
            AccessStatistics stats = new AccessStatistics();
            if (verbose) {
                statistics = new VerboseStatistics(stats, new DefaultCounts(numberOfThreads), log);
                storeAccess = new AccessStatsKeepingStoreAccess(neoStores, stats);
            } else {
                statistics = Statistics.NONE;
                storeAccess = new StoreAccess(neoStores);
            }
            storeAccess.initialize();
            DirectStoreAccess stores = new DirectStoreAccess(storeAccess, (LabelScanStore)labelScanStore, indexes);
            FullCheck check = new FullCheck(progressFactory, statistics, numberOfThreads, consistencyFlags, config);
            summary = check.execute(stores, (Log)new DuplicatingLog(new Log[]{log, reportLog}));
        }
        finally {
            life.shutdown();
        }
        if (!summary.isConsistent()) {
            log.warn("See '%s' for a detailed consistency report.", new Object[]{reportFile.getPath()});
            return Result.failure(reportFile);
        }
        return Result.success(reportFile);
    }

    private File chooseReportPath(File reportDir) {
        return new File(reportDir, ConsistencyCheckService.defaultLogFileName(this.timestamp));
    }

    private File defaultReportDir(Config tuningConfiguration, File storeDir) {
        if (tuningConfiguration.get(GraphDatabaseSettings.neo4j_home) == null) {
            tuningConfiguration.augment(GraphDatabaseSettings.neo4j_home, storeDir.getAbsolutePath());
        }
        return (File)tuningConfiguration.get(GraphDatabaseSettings.logs_directory);
    }

    private static String defaultLogFileName(Date date) {
        return String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date));
    }

    public static int defaultConsistencyCheckThreadsNumber() {
        return Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    }

    public static interface Result {
        public static Result failure(final File reportFile) {
            return new Result(){

                @Override
                public boolean isSuccessful() {
                    return false;
                }

                @Override
                public File reportFile() {
                    return reportFile;
                }
            };
        }

        public static Result success(final File reportFile) {
            return new Result(){

                @Override
                public boolean isSuccessful() {
                    return true;
                }

                @Override
                public File reportFile() {
                    return reportFile;
                }
            };
        }

        public boolean isSuccessful();

        public File reportFile();
    }
}

