/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.impl.api.LookupFilter;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyAndNodeIndexedCheck
implements RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
    private final IndexAccessors indexes;
    private final PropertyReader propertyReader;
    private final CacheAccess cacheAccess;

    public PropertyAndNodeIndexedCheck(IndexAccessors indexes, PropertyReader propertyReader, CacheAccess cacheAccess) {
        this.indexes = indexes;
        this.propertyReader = propertyReader;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public void check(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
        try {
            Collection<PropertyRecord> properties = this.propertyReader.getPropertyRecordChain(record.getNextProp());
            this.cacheAccess.client().putPropertiesToCache(properties);
            if (this.indexes != null) {
                this.matchIndexesToNode(record, engine, records, properties);
            }
            this.checkProperty(record, engine, properties);
        }
        catch (PropertyReader.CircularPropertyRecordChainException e) {
            engine.report().propertyChainContainsCircularReference(e.propertyRecordClosingTheCircle());
        }
    }

    private void matchIndexesToNode(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, Collection<PropertyRecord> propertyRecs) {
        Set<Long> labels = NodeLabelReader.getListOfLabels(record, records, engine);
        PrimitiveIntObjectMap<PropertyBlock> nodePropertyMap = null;
        for (IndexRule indexRule : this.indexes.onlineRules()) {
            int[] indexPropertyIds;
            long labelId = indexRule.schema().getLabelId();
            if (!labels.contains(labelId)) continue;
            if (nodePropertyMap == null) {
                nodePropertyMap = this.properties(this.propertyReader.propertyBlocks(propertyRecs));
            }
            if (!PropertyAndNodeIndexedCheck.nodeHasSchemaProperties(nodePropertyMap, indexPropertyIds = indexRule.schema().getPropertyIds())) continue;
            Value[] values = this.getPropertyValues(nodePropertyMap, indexPropertyIds);
            IndexReader reader = this.indexes.accessorFor(indexRule).newReader();
            Throwable throwable = null;
            try {
                long nodeId = record.getId();
                if (indexRule.canSupportUniqueConstraint()) {
                    this.verifyNodeCorrectlyIndexedUniquely(nodeId, values, engine, indexRule, reader);
                    continue;
                }
                long count = reader.countIndexedNodes(nodeId, values);
                this.reportIncorrectIndexCount(values, engine, indexRule, count);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    private void verifyNodeCorrectlyIndexedUniquely(long nodeId, Value[] propertyValues, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, IndexRule indexRule, IndexReader reader) {
        IndexQuery[] query = this.seek(indexRule.schema(), propertyValues);
        PrimitiveLongIterator indexedNodeIds = this.queryIndexOrEmpty(reader, query);
        long count = 0L;
        while (indexedNodeIds.hasNext()) {
            long indexedNodeId = indexedNodeIds.next();
            if (nodeId == indexedNodeId) {
                ++count;
                continue;
            }
            engine.report().uniqueIndexNotUnique(indexRule, Values.asObjects((Value[])propertyValues), indexedNodeId);
        }
        this.reportIncorrectIndexCount(propertyValues, engine, indexRule, count);
    }

    private void reportIncorrectIndexCount(Value[] propertyValues, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, IndexRule indexRule, long count) {
        if (count == 0L) {
            engine.report().notIndexed(indexRule, Values.asObjects((Value[])propertyValues));
        } else if (count != 1L) {
            engine.report().indexedMultipleTimes(indexRule, Values.asObjects((Value[])propertyValues), count);
        }
    }

    private void checkProperty(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, Collection<PropertyRecord> props) {
        if (!Record.NO_NEXT_PROPERTY.is(record.getNextProp())) {
            PropertyRecord firstProp = props.iterator().next();
            if (!Record.NO_PREVIOUS_PROPERTY.is(firstProp.getPrevProp())) {
                engine.report().propertyNotFirstInChain(firstProp);
            }
            PrimitiveIntSet keys = Primitive.intSet();
            for (PropertyRecord property : props) {
                if (!property.inUse()) {
                    engine.report().propertyNotInUse(property);
                    continue;
                }
                for (int key : ChainCheck.keys(property)) {
                    if (keys.add(key)) continue;
                    engine.report().propertyKeyNotUniqueInChain();
                }
            }
        }
    }

    private Value[] getPropertyValues(PrimitiveIntObjectMap<PropertyBlock> propertyMap, int[] indexPropertyIds) {
        Value[] values = new Value[indexPropertyIds.length];
        for (int i = 0; i < indexPropertyIds.length; ++i) {
            PropertyBlock propertyBlock = (PropertyBlock)propertyMap.get(indexPropertyIds[i]);
            values[i] = this.propertyReader.propertyValue(propertyBlock);
        }
        return values;
    }

    private PrimitiveIntObjectMap<PropertyBlock> properties(List<PropertyBlock> propertyBlocks) {
        PrimitiveIntObjectMap propertyIds = Primitive.intObjectMap();
        for (PropertyBlock propertyBlock : propertyBlocks) {
            propertyIds.put(propertyBlock.getKeyIndexId(), (Object)propertyBlock);
        }
        return propertyIds;
    }

    private IndexQuery[] seek(LabelSchemaDescriptor schema, Value[] propertyValues) {
        assert (schema.getPropertyIds().length == propertyValues.length);
        IndexQuery[] query = new IndexQuery[propertyValues.length];
        for (int i = 0; i < query.length; ++i) {
            query[i] = IndexQuery.exact((int)schema.getPropertyIds()[i], (Object)propertyValues[i]);
        }
        return query;
    }

    private PrimitiveLongIterator queryIndexOrEmpty(IndexReader reader, IndexQuery[] query) {
        PrimitiveLongIterator indexedNodeIds;
        try {
            indexedNodeIds = reader.query(query);
        }
        catch (IndexNotApplicableKernelException e) {
            throw new RuntimeException(String.format("Consistency checking error: index provider does not support exact query %s", Arrays.toString(query)), e);
        }
        return reader.hasFullNumberPrecision(query) ? indexedNodeIds : LookupFilter.exactIndexMatches((PropertyAccessor)this.propertyReader, (PrimitiveLongIterator)indexedNodeIds, (IndexQuery[])query);
    }

    private static boolean nodeHasSchemaProperties(PrimitiveIntObjectMap<PropertyBlock> nodePropertyMap, int[] indexPropertyIds) {
        for (int indexPropertyId : indexPropertyIds) {
            if (nodePropertyMap.containsKey(indexPropertyId)) continue;
            return false;
        }
        return true;
    }
}

