/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;

public class IndexAccessors
implements Closeable {
    private final Map<Long, IndexAccessor> accessors = new HashMap<Long, IndexAccessor>();
    private final List<IndexRule> indexRules = new ArrayList<IndexRule>();

    public IndexAccessors(SchemaIndexProvider provider, RecordStore<DynamicRecord> schemaStore, IndexSamplingConfig samplingConfig) throws IOException {
        Iterator rules = new SchemaStorage(schemaStore).indexesGetAll();
        while (true) {
            try {
                while (rules.hasNext()) {
                    IndexRule indexRule = (IndexRule)rules.next();
                    if (InternalIndexState.ONLINE != provider.getInitialState(indexRule.getId(), indexRule.getIndexDescriptor())) continue;
                    this.indexRules.add(indexRule);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        for (IndexRule indexRule : this.indexRules) {
            long indexId = indexRule.getId();
            this.accessors.put(indexId, provider.getOnlineAccessor(indexId, indexRule.getIndexDescriptor(), samplingConfig));
        }
    }

    public IndexAccessor accessorFor(IndexRule indexRule) {
        return this.accessors.get(indexRule.getId());
    }

    public Iterable<IndexRule> rules() {
        return this.indexRules;
    }

    @Override
    public void close() throws IOException {
        for (IndexAccessor accessor : this.accessors.values()) {
            accessor.close();
        }
        this.accessors.clear();
        this.indexRules.clear();
    }
}

