/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.RecordDistributor;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public interface QueueDistribution {
    public static final QueueDistribution ROUND_ROBIN = new QueueDistribution(){

        @Override
        public <RECORD> QueueDistributor<RECORD> distributor(long recordsPerCpu, int numberOfThreads) {
            return new RoundRobinQueueDistributor(numberOfThreads);
        }
    };
    public static final QueueDistribution RELATIONSHIPS = new QueueDistribution(){

        public QueueDistributor<RelationshipRecord> distributor(long recordsPerCpu, int numberOfThreads) {
            return new RelationshipNodesQueueDistributor(recordsPerCpu, numberOfThreads);
        }
    };

    public <RECORD> QueueDistributor<RECORD> distributor(long var1, int var3);

    public static class RelationshipNodesQueueDistributor
    implements QueueDistributor<RelationshipRecord> {
        private final long recordsPerCpu;
        private final int maxAvailableThread;
        private final int numberOfThreads;

        RelationshipNodesQueueDistributor(long recordsPerCpu, int numberOfThreads) {
            this.recordsPerCpu = recordsPerCpu;
            this.numberOfThreads = numberOfThreads;
            this.maxAvailableThread = numberOfThreads - 1;
        }

        @Override
        public void distribute(RelationshipRecord relationship, RecordDistributor.RecordConsumer<RelationshipRecord> consumer) throws InterruptedException {
            int qIndex1 = (int)Math.min((long)this.maxAvailableThread, Math.abs(relationship.getFirstNode()) / this.recordsPerCpu);
            int qIndex2 = (int)Math.min((long)this.maxAvailableThread, Math.abs(relationship.getSecondNode()) / this.recordsPerCpu);
            try {
                consumer.accept(relationship, qIndex1);
                if (qIndex1 != qIndex2) {
                    consumer.accept(relationship, qIndex2);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw (ArrayIndexOutOfBoundsException)Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + ", recordsPerCPU:" + this.recordsPerCpu + ", relationship:" + relationship + ", number of threads: " + this.numberOfThreads));
            }
        }
    }

    public static class RoundRobinQueueDistributor<RECORD>
    implements QueueDistributor<RECORD> {
        private final int numberOfThreads;
        private int nextQIndex;

        RoundRobinQueueDistributor(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
        }

        @Override
        public void distribute(RECORD record, RecordDistributor.RecordConsumer<RECORD> consumer) throws InterruptedException {
            try {
                consumer.accept(record, this.nextQIndex);
            }
            finally {
                this.nextQIndex = (this.nextQIndex + 1) % this.numberOfThreads;
            }
        }
    }

    public static interface QueueDistributor<RECORD> {
        public void distribute(RECORD var1, RecordDistributor.RecordConsumer<RECORD> var2) throws InterruptedException;
    }
}

