/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.kernel.impl.store.record.IndexRule;

public class IndexCheck
implements RecordCheck<IndexEntry, ConsistencyReport.IndexConsistencyReport> {
    private final IndexRule indexRule;

    public IndexCheck(IndexRule indexRule) {
        this.indexRule = indexRule;
    }

    @Override
    public void check(IndexEntry record, CheckerEngine<IndexEntry, ConsistencyReport.IndexConsistencyReport> engine, RecordAccess records) {
        int labelId = this.indexRule.getSchemaDescriptor().getLabelId();
        engine.comparativeCheck(records.node(record.getId()), new NodeInUseWithCorrectLabelsCheck(new long[]{labelId}, false));
    }
}

