/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodePropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Utils;

public class MandatoryProperties {
    private static final Class<PropertyConstraintRule> BASE_RULE = PropertyConstraintRule.class;
    private final PrimitiveIntObjectMap<int[]> nodes = Primitive.intObjectMap();
    private final PrimitiveIntObjectMap<int[]> relationships = Primitive.intObjectMap();
    private final StoreAccess storeAccess;
    private static final Check NONE = new Check(){

        @Override
        public void receive(int[] keys) {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "NONE";
        }
    };

    public MandatoryProperties(StoreAccess storeAccess) {
        this.storeAccess = storeAccess;
        SchemaStorage schemaStorage = new SchemaStorage(storeAccess.getSchemaStore());
        Iterator rules = schemaStorage.schemaRules(BASE_RULE);
        block4: while (this.safeHasNext(rules)) {
            int propertyKey;
            int labelOrRelType;
            PrimitiveIntObjectMap<int[]> storage;
            PropertyConstraintRule rule = (PropertyConstraintRule)rules.next();
            switch (rule.getKind()) {
                case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                    storage = this.nodes;
                    NodePropertyExistenceConstraintRule nodeRule = (NodePropertyExistenceConstraintRule)rule;
                    labelOrRelType = nodeRule.getLabel();
                    propertyKey = nodeRule.getPropertyKey();
                    break;
                }
                case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                    storage = this.relationships;
                    RelationshipPropertyExistenceConstraintRule relRule = (RelationshipPropertyExistenceConstraintRule)rule;
                    labelOrRelType = relRule.getRelationshipType();
                    propertyKey = relRule.getPropertyKey();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            MandatoryProperties.recordConstraint(labelOrRelType, propertyKey, storage);
        }
    }

    public Function<NodeRecord, Check<NodeRecord, ConsistencyReport.NodeConsistencyReport>> forNodes(ConsistencyReporter reporter) {
        return node -> {
            PrimitiveIntSet keys = null;
            for (long labelId : NodeLabelReader.getListOfLabels(node, (RecordStore<DynamicRecord>)this.storeAccess.getNodeDynamicLabelStore())) {
                int[] propertyKeys = (int[])this.nodes.get(Utils.safeCastLongToInt((long)labelId));
                if (propertyKeys == null) continue;
                if (keys == null) {
                    keys = Primitive.intSet((int)16);
                }
                for (int key : propertyKeys) {
                    keys.add(key);
                }
            }
            return keys != null ? new RealCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport>((NodeRecord)node, ConsistencyReport.NodeConsistencyReport.class, reporter, RecordType.NODE, keys) : MandatoryProperties.noCheck();
        };
    }

    public Function<RelationshipRecord, Check<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>> forRelationships(ConsistencyReporter reporter) {
        return relationship -> {
            int[] propertyKeys = (int[])this.relationships.get(relationship.getType());
            if (propertyKeys != null) {
                PrimitiveIntSet keys = Primitive.intSet((int)propertyKeys.length);
                for (int key : propertyKeys) {
                    keys.add(key);
                }
                return new RealCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>((RelationshipRecord)relationship, ConsistencyReport.RelationshipConsistencyReport.class, reporter, RecordType.RELATIONSHIP, keys);
            }
            return MandatoryProperties.noCheck();
        };
    }

    private boolean safeHasNext(Iterator<?> iterator) {
        while (true) {
            try {
                return iterator.hasNext();
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static void recordConstraint(int labelOrRelType, int propertyKey, PrimitiveIntObjectMap<int[]> storage) {
        int[] propertyKeys = (int[])storage.get(labelOrRelType);
        if (propertyKeys == null) {
            propertyKeys = new int[]{propertyKey};
        } else {
            propertyKeys = Arrays.copyOf(propertyKeys, propertyKeys.length + 1);
            propertyKeys[propertyKeys.length - 1] = propertyKey;
        }
        storage.put(labelOrRelType, (Object)propertyKeys);
    }

    private static <RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport> Check<RECORD, REPORT> noCheck() {
        return NONE;
    }

    private static class RealCheck<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
    implements Check<RECORD, REPORT> {
        private final RECORD record;
        private final PrimitiveIntSet mandatoryKeys;
        private final Class<REPORT> reportClass;
        private final ConsistencyReporter reporter;
        private final RecordType recordType;

        RealCheck(RECORD record, Class<REPORT> reportClass, ConsistencyReporter reporter, RecordType recordType, PrimitiveIntSet mandatoryKeys) {
            this.record = record;
            this.reportClass = reportClass;
            this.reporter = reporter;
            this.recordType = recordType;
            this.mandatoryKeys = mandatoryKeys;
        }

        @Override
        public void receive(int[] keys) {
            for (int key : keys) {
                this.mandatoryKeys.remove(key);
            }
        }

        @Override
        public void close() {
            if (!this.mandatoryKeys.isEmpty()) {
                PrimitiveIntIterator key = this.mandatoryKeys.iterator();
                while (key.hasNext()) {
                    ((ConsistencyReport.PrimitiveConsistencyReport)this.reporter.report(this.record, this.reportClass, this.recordType)).missingMandatoryProperty(key.next());
                }
            }
        }

        public String toString() {
            return "Mandatory properties: " + this.mandatoryKeys;
        }
    }

    public static interface Check<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
    extends AutoCloseable {
        public void receive(int[] var1);

        @Override
        public void close();
    }
}

