/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.labelscan;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.synthetic.LabelScanDocument;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;

public class LabelScanCheck
implements RecordCheck<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> {
    @Override
    public void check(LabelScanDocument record, CheckerEngine<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> engine, RecordAccess records) {
        NodeLabelRange range = record.getNodeLabelRange();
        for (long nodeId : range.nodes()) {
            engine.comparativeCheck(records.node(nodeId), new NodeInUseWithCorrectLabelsCheck(record.getNodeLabelRange().labels(nodeId)));
        }
    }
}

