/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.IterableStore;
import org.neo4j.consistency.checking.full.RecordDistributor;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.full.RecordScanner;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.progress.ProgressMonitorFactory;

public class ParallelRecordScanner<RECORD>
extends RecordScanner<RECORD> {
    private final CacheAccess cacheAccess;

    public ParallelRecordScanner(String name, Statistics statistics, int threads, BoundedIterable<RECORD> store, ProgressMonitorFactory.MultiPartBuilder builder, RecordProcessor<RECORD> processor, CacheAccess cacheAccess, IterableStore ... warmUpStores) {
        super(name, statistics, threads, store, builder, processor, warmUpStores);
        this.cacheAccess = cacheAccess;
    }

    @Override
    protected void scan() {
        long recordsPerCPU = this.store.maxCount() / (long)this.numberOfThreads + 1L;
        this.cacheAccess.prepareForProcessingOfSingleStore(recordsPerCPU);
        RecordDistributor.distributeRecords(this.numberOfThreads, this.getClass().getSimpleName() + "-" + this.name, 1000, this.store, this.progress, this.processor);
    }
}

