/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.paging;

import org.neo4j.consistency.store.paging.CachedPageList;
import org.neo4j.consistency.store.paging.TemporalUtility;
import org.neo4j.consistency.store.paging.TemporalUtilityCounter;

public abstract class Page<T> {
    boolean referenced = false;
    TemporalUtility utility = TemporalUtility.UNKNOWN;
    CachedPageList currentList = null;
    Page prevPage;
    Page nextPage;
    T payload;

    Page moveToTailOf(CachedPageList targetList) {
        if (this.currentList != null) {
            if (this.prevPage != null) {
                this.prevPage.nextPage = this.nextPage;
            }
            if (this.nextPage != null) {
                this.nextPage.prevPage = this.prevPage;
            }
            if (this.currentList.head == this) {
                this.currentList.head = this.nextPage;
            }
            if (this.currentList.tail == this) {
                this.currentList.tail = this.prevPage;
            }
            this.currentList.decrementSize();
        }
        if (targetList != null) {
            this.prevPage = targetList.tail;
            if (this.prevPage != null) {
                this.prevPage.nextPage = this;
            }
            targetList.tail = this;
            if (targetList.head == null) {
                targetList.head = this;
            }
            targetList.incrementSize();
        }
        this.nextPage = null;
        this.currentList = targetList;
        return this;
    }

    Page setReferenced() {
        this.referenced = true;
        return this;
    }

    Page clearReference() {
        this.referenced = false;
        return this;
    }

    Page setUtility(TemporalUtilityCounter counter, TemporalUtility utility) {
        counter.decrement(this.utility);
        this.utility = utility;
        counter.increment(this.utility);
        return this;
    }

    final void evict() {
        try {
            if (this.payload != null) {
                this.evict(this.payload);
            }
        }
        finally {
            this.payload = null;
        }
    }

    protected abstract void evict(T var1);

    public String toString() {
        return String.format("Page{payload=%s, inAList=%b}", this.payload, this.currentList != null);
    }

    protected abstract void hit();
}

