/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodePropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaRecordCheck
implements RecordCheck<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> {
    final SchemaRuleAccess ruleAccess;
    private final Map<Long, DynamicRecord> indexObligations;
    private final Map<Long, DynamicRecord> constraintObligations;
    private final Map<SchemaRule, DynamicRecord> verifiedRulesWithRecords;
    private final CheckStrategy strategy;
    private static final ComparativeRecordChecker<DynamicRecord, LabelTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_LABEL = new ComparativeRecordChecker<DynamicRecord, LabelTokenRecord, ConsistencyReport.SchemaConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, LabelTokenRecord labelTokenRecord, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine, RecordAccess records) {
            if (!labelTokenRecord.inUse()) {
                engine.report().labelNotInUse(labelTokenRecord);
            }
        }
    };
    private static final ComparativeRecordChecker<DynamicRecord, RelationshipTypeTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_RELATIONSHIP_TYPE = new ComparativeRecordChecker<DynamicRecord, RelationshipTypeTokenRecord, ConsistencyReport.SchemaConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, RelationshipTypeTokenRecord relTypeTokenRecord, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine, RecordAccess records) {
            if (!relTypeTokenRecord.inUse()) {
                engine.report().relationshipTypeNotInUse(relTypeTokenRecord);
            }
        }
    };
    private static final ComparativeRecordChecker<DynamicRecord, PropertyKeyTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_PROPERTY_KEY = new ComparativeRecordChecker<DynamicRecord, PropertyKeyTokenRecord, ConsistencyReport.SchemaConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, PropertyKeyTokenRecord propertyKeyTokenRecord, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine, RecordAccess records) {
            if (!propertyKeyTokenRecord.inUse()) {
                engine.report().propertyKeyNotInUse(propertyKeyTokenRecord);
            }
        }
    };

    public SchemaRecordCheck(SchemaRuleAccess ruleAccess) {
        this.ruleAccess = ruleAccess;
        this.indexObligations = new HashMap<Long, DynamicRecord>();
        this.constraintObligations = new HashMap<Long, DynamicRecord>();
        this.verifiedRulesWithRecords = new HashMap<SchemaRule, DynamicRecord>();
        this.strategy = new RulesCheckStrategy();
    }

    private SchemaRecordCheck(SchemaRuleAccess ruleAccess, Map<Long, DynamicRecord> indexObligations, Map<Long, DynamicRecord> constraintObligations, Map<SchemaRule, DynamicRecord> verifiedRulesWithRecords, CheckStrategy strategy) {
        this.ruleAccess = ruleAccess;
        this.indexObligations = indexObligations;
        this.constraintObligations = constraintObligations;
        this.verifiedRulesWithRecords = verifiedRulesWithRecords;
        this.strategy = strategy;
    }

    public SchemaRecordCheck forObligationChecking() {
        return new SchemaRecordCheck(this.ruleAccess, this.indexObligations, this.constraintObligations, this.verifiedRulesWithRecords, new ObligationsCheckStrategy());
    }

    @Override
    public void check(DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine, RecordAccess records) {
        if (record.inUse() && record.isStartRecord()) {
            SchemaRule rule;
            try {
                rule = this.ruleAccess.loadSingleSchemaRule(record.getId());
            }
            catch (MalformedSchemaRuleException e) {
                engine.report().malformedSchemaRule();
                return;
            }
            SchemaRule.Kind kind = rule.getKind();
            switch (kind) {
                case INDEX_RULE: 
                case CONSTRAINT_INDEX_RULE: {
                    this.strategy.checkIndexRule((IndexRule)rule, record, records, engine);
                    break;
                }
                case UNIQUENESS_CONSTRAINT: {
                    this.strategy.checkUniquenessConstraintRule((UniquePropertyConstraintRule)rule, record, records, engine);
                    break;
                }
                case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                    this.strategy.checkNodePropertyExistenceRule((NodePropertyExistenceConstraintRule)rule, record, records, engine);
                    break;
                }
                case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                    this.strategy.checkRelationshipPropertyExistenceRule((RelationshipPropertyExistenceConstraintRule)rule, record, records, engine);
                    break;
                }
                default: {
                    engine.report().unsupportedSchemaRuleKind(kind);
                }
            }
        }
    }

    private void checkLabelAndPropertyRule(SchemaRule rule, int propertyKey, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        engine.comparativeCheck(records.label(rule.getLabel()), VALID_LABEL);
        engine.comparativeCheck(records.propertyKey(propertyKey), VALID_PROPERTY_KEY);
        this.checkForDuplicates(rule, record, engine);
    }

    private void checkRelTypeAndPropertyRule(SchemaRule rule, int propertyKey, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        engine.comparativeCheck(records.relationshipType(rule.getRelationshipType()), VALID_RELATIONSHIP_TYPE);
        engine.comparativeCheck(records.propertyKey(propertyKey), VALID_PROPERTY_KEY);
        this.checkForDuplicates(rule, record, engine);
    }

    private void checkForDuplicates(SchemaRule rule, DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        DynamicRecord previousContentRecord = this.verifiedRulesWithRecords.put(rule, record);
        if (previousContentRecord != null) {
            engine.report().duplicateRuleContent(previousContentRecord);
        }
    }

    private class ObligationsCheckStrategy
    implements CheckStrategy {
        private ObligationsCheckStrategy() {
        }

        @Override
        public void checkIndexRule(IndexRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            if (rule.isConstraintIndex()) {
                DynamicRecord obligation = (DynamicRecord)SchemaRecordCheck.this.indexObligations.get(rule.getId());
                if (obligation == null) {
                    if (rule.getOwningConstraint() != null) {
                        engine.report().missingObligation(SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
                    }
                } else if (obligation.getId() != rule.getOwningConstraint().longValue()) {
                    engine.report().constraintIndexRuleNotReferencingBack(obligation);
                }
            }
        }

        @Override
        public void checkUniquenessConstraintRule(UniquePropertyConstraintRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            DynamicRecord obligation = (DynamicRecord)SchemaRecordCheck.this.constraintObligations.get(rule.getId());
            if (obligation == null) {
                engine.report().missingObligation(SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
            } else if (obligation.getId() != rule.getOwnedIndex()) {
                engine.report().uniquenessConstraintNotReferencingBack(obligation);
            }
        }

        @Override
        public void checkNodePropertyExistenceRule(NodePropertyExistenceConstraintRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        }

        @Override
        public void checkRelationshipPropertyExistenceRule(RelationshipPropertyExistenceConstraintRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        }
    }

    private class RulesCheckStrategy
    implements CheckStrategy {
        private RulesCheckStrategy() {
        }

        @Override
        public void checkIndexRule(IndexRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            DynamicRecord previousObligation;
            SchemaRecordCheck.this.checkLabelAndPropertyRule((SchemaRule)rule, rule.getPropertyKey(), record, records, engine);
            if (rule.isConstraintIndex() && rule.getOwningConstraint() != null && (previousObligation = SchemaRecordCheck.this.constraintObligations.put(rule.getOwningConstraint(), record)) != null) {
                engine.report().duplicateObligation(previousObligation);
            }
        }

        @Override
        public void checkUniquenessConstraintRule(UniquePropertyConstraintRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            SchemaRecordCheck.this.checkLabelAndPropertyRule((SchemaRule)rule, rule.getPropertyKey(), record, records, engine);
            DynamicRecord previousObligation = SchemaRecordCheck.this.indexObligations.put(rule.getOwnedIndex(), record);
            if (previousObligation != null) {
                engine.report().duplicateObligation(previousObligation);
            }
        }

        @Override
        public void checkNodePropertyExistenceRule(NodePropertyExistenceConstraintRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            SchemaRecordCheck.this.checkLabelAndPropertyRule((SchemaRule)rule, rule.getPropertyKey(), record, records, engine);
        }

        @Override
        public void checkRelationshipPropertyExistenceRule(RelationshipPropertyExistenceConstraintRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            SchemaRecordCheck.this.checkRelTypeAndPropertyRule((SchemaRule)rule, rule.getPropertyKey(), record, records, engine);
        }
    }

    private static interface CheckStrategy {
        public void checkIndexRule(IndexRule var1, DynamicRecord var2, RecordAccess var3, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> var4);

        public void checkUniquenessConstraintRule(UniquePropertyConstraintRule var1, DynamicRecord var2, RecordAccess var3, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> var4);

        public void checkNodePropertyExistenceRule(NodePropertyExistenceConstraintRule var1, DynamicRecord var2, RecordAccess var3, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> var4);

        public void checkRelationshipPropertyExistenceRule(RelationshipPropertyExistenceConstraintRule var1, DynamicRecord var2, RecordAccess var3, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> var4);
    }
}

