/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.statistics;

import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class AccessStatsKeepingStoreAccess
extends StoreAccess {
    private final AccessStatistics accessStatistics;

    public AccessStatsKeepingStoreAccess(NeoStores neoStore, AccessStatistics accessStatistics) {
        super(neoStore);
        this.accessStatistics = accessStatistics;
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        AccessStatistics.AccessStats accessStats = new AccessStatistics.AccessStats(store.getClass().getSimpleName(), store.getRecordsPerPage());
        this.accessStatistics.register(store, accessStats);
        return new AccessStatsKeepingRecordStore<R>(store, accessStats);
    }

    private static class AccessStatsKeepingRecordStore<RECORD extends AbstractBaseRecord>
    extends RecordStore.Delegator<RECORD> {
        private final AccessStatistics.AccessStats accessStats;

        public AccessStatsKeepingRecordStore(RecordStore<RECORD> actual, AccessStatistics.AccessStats accessStats) {
            super(actual);
            this.accessStats = accessStats;
        }

        protected AccessStatistics.AccessStats getAccessStats() {
            return this.accessStats;
        }

        public RECORD getRecord(long id) {
            this.accessStats.upRead(id);
            return (RECORD)super.getRecord(id);
        }

        public RECORD forceGetRecord(long id) {
            this.accessStats.upRead(id);
            return (RECORD)super.forceGetRecord(id);
        }
    }
}

