/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.RecordDistributor;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public interface QueueDistribution {
    public static final QueueDistribution ROUND_ROBIN = new QueueDistribution(){

        @Override
        public <RECORD> QueueDistributor<RECORD> distributor(long recordsPerCpu, int numberOfThreads) {
            return new RoundRobinQueueDistributor(numberOfThreads);
        }
    };
    public static final QueueDistribution RELATIONSHIPS = new QueueDistribution(){

        public QueueDistributor<RelationshipRecord> distributor(long recordsPerCpu, int numberOfThreads) {
            return new RelationshipNodesQueueDistributor(recordsPerCpu);
        }
    };

    public <RECORD> QueueDistributor<RECORD> distributor(long var1, int var3);

    public static class RelationshipNodesQueueDistributor
    implements QueueDistributor<RelationshipRecord> {
        private final long recordsPerCpu;

        public RelationshipNodesQueueDistributor(long recordsPerCpu) {
            this.recordsPerCpu = recordsPerCpu;
        }

        @Override
        public void distribute(RelationshipRecord relationship, RecordDistributor.RecordConsumer<RelationshipRecord> consumer) throws InterruptedException {
            int qIndex1 = (int)(relationship.getFirstNode() / this.recordsPerCpu);
            int qIndex2 = (int)(relationship.getSecondNode() / this.recordsPerCpu);
            try {
                consumer.accept(relationship, qIndex1);
                if (qIndex1 != qIndex2) {
                    consumer.accept(relationship, qIndex2);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw (ArrayIndexOutOfBoundsException)Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + ", recordsPerCPU:" + this.recordsPerCpu + ", relationship:" + relationship));
            }
        }
    }

    public static class RoundRobinQueueDistributor<RECORD>
    implements QueueDistributor<RECORD> {
        private final int numberOfThreads;
        private int nextQIndex;

        public RoundRobinQueueDistributor(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void distribute(RECORD record, RecordDistributor.RecordConsumer<RECORD> consumer) throws InterruptedException {
            try {
                consumer.accept(record, this.nextQIndex);
            }
            finally {
                this.nextQIndex = (this.nextQIndex + 1) % this.numberOfThreads;
            }
        }
    }

    public static interface QueueDistributor<RECORD> {
        public void distribute(RECORD var1, RecordDistributor.RecordConsumer<RECORD> var2) throws InterruptedException;
    }
}

