/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.statistics;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class AccessStatistics {
    public static int LOCALITY = 500;
    private final Map<RecordStore<? extends AbstractBaseRecord>, AccessStats> stats = new HashMap<RecordStore<? extends AbstractBaseRecord>, AccessStats>();
    private int proximity;

    public AccessStats getAccessStats(RecordStore<? extends AbstractBaseRecord> store) {
        return this.stats.get(store);
    }

    public void register(RecordStore<? extends AbstractBaseRecord> store, AccessStats accessStats) {
        assert (!this.stats.containsKey(store));
        this.stats.put(store, accessStats);
    }

    public String getAccessStatSummary() {
        String msg = "";
        for (AccessStats accessStats : this.stats.values()) {
            String accessStat = accessStats.toString();
            if (accessStat.length() == 0) continue;
            msg = msg + String.format(accessStat + "%n", new Object[0]);
        }
        return msg;
    }

    public void reset() {
        for (AccessStats accessStats : this.stats.values()) {
            accessStats.reset();
        }
    }

    public static class AccessStats {
        private long reads = 0L;
        private long writes = 0L;
        private long inUse = 0L;
        private long randomReads = 0L;
        private long randomWrites = 0L;
        private int proximityValue = 0;
        private final String storeType;
        private long prevReadId;
        private long prevWriteId;

        public AccessStats(String type, int proximity) {
            this.storeType = type;
            this.proximityValue = proximity;
        }

        public String toString() {
            if (this.reads == 0L && this.writes == 0L && this.randomReads == 0L) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.storeType);
            this.appendStat(buf, "InUse", this.inUse);
            this.appendStat(buf, "Reads", this.reads);
            this.appendStat(buf, "Random Reads", this.randomReads);
            this.appendStat(buf, "Writes", this.writes);
            this.appendStat(buf, "Random Writes", this.randomWrites);
            int scatterIndex = 0;
            if (this.randomReads > 0L) {
                long scatterReads = this.reads == 0L ? this.randomReads : this.reads;
                scatterIndex = (int)(this.randomReads * 100L / scatterReads);
            }
            this.appendStat(buf, "ScatterIndex", scatterIndex);
            return buf.toString();
        }

        private void appendStat(StringBuilder target, String name, long stat) {
            if (stat > 0L) {
                target.append(String.format("%n  %s: %d", name, stat));
            }
        }

        public void reset() {
            this.reads = 0L;
            this.writes = 0L;
            this.randomReads = 0L;
            this.randomReads = 0L;
            this.randomWrites = 0L;
            this.inUse = 0L;
        }

        public void upRead(long id) {
            if (this.prevReadId != id) {
                ++this.reads;
                this.incrementRandomReads(id, this.prevReadId);
                this.prevReadId = id;
            }
        }

        private boolean closeBy(long id1, long id2) {
            if (id1 < 0L || id2 < 0L) {
                return true;
            }
            return Math.abs(id2 - id1) < (long)this.proximityValue;
        }

        public void upWrite(long id) {
            if (this.prevWriteId != id) {
                ++this.writes;
                if (id > 0L && !this.closeBy(id, this.prevWriteId)) {
                    ++this.randomWrites;
                }
                this.prevWriteId = id;
            }
        }

        public synchronized void incrementRandomReads(long id1, long id2) {
            if (!this.closeBy(id1, id2)) {
                ++this.randomReads;
            }
        }

        public synchronized void upInUse() {
            ++this.inUse;
        }
    }
}

