/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodePropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class PropertyExistenceChecker
extends CheckDecorator.Adapter {
    private static final Class<PropertyConstraintRule> BASE_RULE = PropertyConstraintRule.class;
    private final PrimitiveIntObjectMap<int[]> nodes = Primitive.intObjectMap();
    private final PrimitiveIntObjectMap<int[]> relationships = Primitive.intObjectMap();

    public PropertyExistenceChecker(RecordStore<DynamicRecord> schemaStore) {
        SchemaStorage schemaStorage = new SchemaStorage(schemaStore);
        Iterator rules = schemaStorage.schemaRules(BASE_RULE);
        block4: while (this.safeHasNext(rules)) {
            int propertyKey;
            int labelOrRelType;
            PrimitiveIntObjectMap<int[]> storage;
            PropertyConstraintRule rule = (PropertyConstraintRule)rules.next();
            switch (rule.getKind()) {
                case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                    storage = this.nodes;
                    NodePropertyExistenceConstraintRule nodeRule = (NodePropertyExistenceConstraintRule)rule;
                    labelOrRelType = nodeRule.getLabel();
                    propertyKey = nodeRule.getPropertyKey();
                    break;
                }
                case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                    storage = this.relationships;
                    RelationshipPropertyExistenceConstraintRule relRule = (RelationshipPropertyExistenceConstraintRule)rule;
                    labelOrRelType = relRule.getRelationshipType();
                    propertyKey = relRule.getPropertyKey();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            PropertyExistenceChecker.recordConstraint(labelOrRelType, propertyKey, storage);
        }
    }

    private boolean safeHasNext(Iterator<?> iterator) {
        while (true) {
            try {
                return iterator.hasNext();
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static void recordConstraint(int labelOrRelType, int propertyKey, PrimitiveIntObjectMap<int[]> storage) {
        int[] propertyKeys = (int[])storage.get(labelOrRelType);
        if (propertyKeys == null) {
            propertyKeys = new int[]{propertyKey};
        } else {
            propertyKeys = Arrays.copyOf(propertyKeys, propertyKeys.length + 1);
            propertyKeys[propertyKeys.length - 1] = propertyKey;
        }
        storage.put(labelOrRelType, (Object)propertyKeys);
    }

    @Override
    public OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> decorateNodeChecker(OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        if (this.nodes.isEmpty()) {
            return checker;
        }
        return new NodeChecker(this.nodes, checker);
    }

    @Override
    public OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> decorateRelationshipChecker(OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        if (this.relationships.isEmpty()) {
            return checker;
        }
        return new RelationshipChecker(this.relationships, checker);
    }

    static void reportMissingKeys(ConsistencyReport.PrimitiveConsistencyReport report, PrimitiveIntSet keys) {
        PrimitiveIntIterator key = keys.iterator();
        while (key.hasNext()) {
            report.missingMandatoryProperty(key.next());
        }
    }

    private static class SizeCounter
    implements PrimitiveIntObjectVisitor<int[], RuntimeException> {
        private int size;

        private SizeCounter() {
        }

        static int countSizeOf(PrimitiveIntObjectMap<int[]> map) {
            SizeCounter counter = new SizeCounter();
            map.visitEntries((PrimitiveIntObjectVisitor)counter);
            return counter.size;
        }

        public boolean visited(int key, int[] ints) throws RuntimeException {
            this.size += ints.length;
            return false;
        }
    }

    private static class ChainCheck<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
    implements ComparativeRecordChecker<RECORD, PropertyRecord, REPORT> {
        private static final int MAX_BLOCK_PER_RECORD_COUNT = 4;
        private final PrimitiveIntSet keys;

        public ChainCheck(PrimitiveIntSet keys) {
            this.keys = keys;
        }

        @Override
        public void checkReference(RECORD record, PropertyRecord property, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            for (int key : ChainCheck.keys(property)) {
                this.keys.remove(key);
            }
            if (Record.NO_NEXT_PROPERTY.is(property.getNextProp()) && !this.keys.isEmpty()) {
                PropertyExistenceChecker.reportMissingKeys((ConsistencyReport.PrimitiveConsistencyReport)engine.report(), this.keys);
            }
        }

        static int[] keys(PropertyRecord property) {
            int[] toStartWith = new int[4];
            int index = 0;
            for (PropertyBlock propertyBlock : property) {
                toStartWith[index++] = propertyBlock.getKeyIndexId();
            }
            return Arrays.copyOf(toStartWith, index);
        }
    }

    static class RelationshipChecker
    extends Checker<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> {
        private final PrimitiveIntObjectMap<int[]> mandatory;

        private RelationshipChecker(PrimitiveIntObjectMap<int[]> mandatory, OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> next) {
            super(next);
            this.mandatory = mandatory;
        }

        @Override
        PrimitiveIntSet mandatoryPropertiesFor(RelationshipRecord record, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
            int[] propertyKeys = (int[])this.mandatory.get(record.getType());
            if (propertyKeys != null) {
                PrimitiveIntSet keys = Primitive.intSet((int)propertyKeys.length);
                for (int key : propertyKeys) {
                    keys.add(key);
                }
                return keys;
            }
            return null;
        }
    }

    static class NodeChecker
    extends Checker<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
        private final PrimitiveIntObjectMap<int[]> mandatory;
        private final int capacity;

        private NodeChecker(PrimitiveIntObjectMap<int[]> mandatory, OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> next) {
            super(next);
            this.mandatory = mandatory;
            this.capacity = SizeCounter.countSizeOf(mandatory);
        }

        @Override
        PrimitiveIntSet mandatoryPropertiesFor(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
            PrimitiveIntSet keys = null;
            for (Long label : NodeLabelReader.getListOfLabels(record, records, engine)) {
                int[] propertyKeys = (int[])this.mandatory.get(label.intValue());
                if (propertyKeys == null) continue;
                if (keys == null) {
                    keys = Primitive.intSet((int)this.capacity);
                }
                for (int key : propertyKeys) {
                    keys.add(key);
                }
            }
            return keys;
        }
    }

    private static abstract class Checker<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
    implements OwningRecordCheck<RECORD, REPORT> {
        private final OwningRecordCheck<RECORD, REPORT> next;

        private Checker(OwningRecordCheck<RECORD, REPORT> next) {
            this.next = next;
        }

        @Override
        public void check(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            PrimitiveIntSet keys;
            this.next.check(record, engine, records);
            if (record.inUse() && (keys = this.mandatoryPropertiesFor(record, engine, records)) != null) {
                this.checkProperties(record, keys, engine, records);
            }
        }

        private void checkProperties(RECORD record, PrimitiveIntSet keys, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            long firstProperty = record.getNextProp();
            if (!Record.NO_NEXT_PROPERTY.is(firstProperty)) {
                engine.comparativeCheck(records.property(firstProperty), new ChainCheck(keys));
            } else {
                PropertyExistenceChecker.reportMissingKeys((ConsistencyReport.PrimitiveConsistencyReport)engine.report(), keys);
            }
        }

        abstract PrimitiveIntSet mandatoryPropertiesFor(RECORD var1, CheckerEngine<RECORD, REPORT> var2, RecordAccess var3);

        @Override
        public ComparativeRecordChecker<RECORD, PrimitiveRecord, REPORT> ownerCheck() {
            return this.next.ownerCheck();
        }

        @Override
        public void checkChange(RECORD oldRecord, RECORD newRecord, CheckerEngine<RECORD, REPORT> engine, DiffRecordAccess records) {
            this.next.checkChange(oldRecord, newRecord, engine, records);
        }
    }
}

