/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental;

import java.io.File;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.incremental.DiffCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DiffStore;
import org.neo4j.logging.LogProvider;

public class LoggingDiffCheck
extends DiffCheck {
    private final DiffCheck checker;

    public LoggingDiffCheck(DiffCheck checker, LogProvider logProvider) {
        super(logProvider);
        this.checker = checker;
    }

    @Override
    public ConsistencySummaryStatistics execute(File storeDir, DiffStore diffs) throws ConsistencyCheckIncompleteException {
        return this.checker.execute(storeDir, diffs);
    }

    @Override
    protected void verify(DiffStore diffs, ConsistencySummaryStatistics summary) {
        if (!summary.isConsistent()) {
            this.log.warn("Inconsistencies found: " + summary);
        }
    }
}

