/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental;

import java.io.File;
import java.util.Collection;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.SchemaRecordCheck;
import org.neo4j.consistency.checking.incremental.DiffCheck;
import org.neo4j.consistency.checking.incremental.StoreProcessor;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.DiffStore;
import org.neo4j.consistency.store.DirectDiffRecordAccess;
import org.neo4j.function.Predicate;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.logging.LogProvider;

public class IncrementalDiffCheck
extends DiffCheck {
    public IncrementalDiffCheck(LogProvider logProvider) {
        super(logProvider);
    }

    @Override
    public ConsistencySummaryStatistics execute(File storeDir, DiffStore diffs) {
        ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
        ConsistencyReporter reporter = new ConsistencyReporter(new DirectDiffRecordAccess(diffs), new InconsistencyReport(new InconsistencyMessageLogger(this.log), summary));
        StoreProcessor processor = new StoreProcessor(reporter);
        diffs.applyToAll(processor);
        if (diffs.getSchemaStore().hasChanges() && 0 == summary.getInconsistencyCountForRecordType(RecordType.SCHEMA)) {
            this.performFullCheckOfSchemaStore(diffs, reporter);
        }
        return summary;
    }

    private void performFullCheckOfSchemaStore(DiffStore diffs, ConsistencyReporter reporter) {
        SchemaRecordCheck schemaChecker = new SchemaRecordCheck(new RuleReader(diffs.getSchemaStore()));
        for (DynamicRecord record : RecordStore.Scanner.scan((RecordStore)diffs.getSchemaStore(), (Predicate[])new Predicate[0])) {
            reporter.forSchema(record, schemaChecker);
        }
        schemaChecker = schemaChecker.forObligationChecking();
        for (DynamicRecord record : RecordStore.Scanner.scan((RecordStore)diffs.getSchemaStore(), (Predicate[])new Predicate[0])) {
            reporter.forSchema(record, schemaChecker);
        }
    }

    private static class RuleReader
    implements SchemaRuleAccess {
        private final RecordStore<DynamicRecord> schemaStore;

        private RuleReader(RecordStore<DynamicRecord> schemaStore) {
            this.schemaStore = schemaStore;
        }

        public SchemaRule loadSingleSchemaRule(long ruleId) throws MalformedSchemaRuleException {
            return SchemaStore.readSchemaRule((long)ruleId, (Collection)this.schemaStore.getRecords(ruleId));
        }
    }
}

