/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental;

import java.io.File;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.checking.incremental.DiffCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DiffStore;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.index.lucene.LuceneLabelScanStoreBuilder;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.logging.LogProvider;

public class FullDiffCheck
extends DiffCheck {
    public FullDiffCheck(LogProvider logProvider) {
        super(logProvider);
    }

    @Override
    public ConsistencySummaryStatistics execute(File storeDir, DiffStore diffs) throws ConsistencyCheckIncompleteException {
        Config tuningConfiguration = new Config(MapUtil.stringMap((String[])new String[0]), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        LabelScanStore labelScanStore = new LuceneLabelScanStoreBuilder(storeDir, diffs.getRawNeoStore(), (FileSystemAbstraction)fileSystem, this.logProvider).build();
        LuceneSchemaIndexProvider indexes = new LuceneSchemaIndexProvider(DirectoryFactory.PERSISTENT, storeDir);
        DirectStoreAccess stores = new DirectStoreAccess((StoreAccess)diffs, labelScanStore, (SchemaIndexProvider)indexes);
        return new FullCheck(tuningConfiguration, ProgressMonitorFactory.NONE).execute(stores, this.log);
    }
}

