/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.PrintWriter;
import org.neo4j.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractPrintWriterLogger;
import org.neo4j.logging.Logger;

public class ConsistencyReportLogger
extends AbstractPrintWriterLogger {
    private final String prefix;

    public ConsistencyReportLogger(Supplier<PrintWriter> writerSupplier, Object lock, String prefix, boolean autoFlush) {
        super(writerSupplier, lock, autoFlush);
        this.prefix = prefix;
    }

    protected void writeLog(PrintWriter out, String message) {
        out.write(this.prefix);
        out.write(": ");
        out.write(message);
        out.println();
    }

    protected void writeLog(PrintWriter out, String message, Throwable throwable) {
        out.write(this.prefix);
        out.write(": ");
        out.write(message);
        out.write(32);
        out.write(throwable.getMessage());
        out.println();
        throwable.printStackTrace(out);
    }

    protected void writeLog(PrintWriter out, String format, Object[] arguments) {
        out.write(this.prefix);
        out.write(": ");
        out.format(format, arguments);
        out.println();
    }

    protected Logger getBulkLogger(PrintWriter out, Object lock) {
        return new ConsistencyReportLogger((Supplier<PrintWriter>)Suppliers.singleton((Object)out), lock, this.prefix, false);
    }
}

