/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import org.neo4j.consistency.repair.RecordSet;
import org.neo4j.consistency.repair.RelationshipChainDirection;
import org.neo4j.consistency.repair.RelationshipNodeField;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipChainExplorer {
    private final RecordStore<RelationshipRecord> recordStore;

    public RelationshipChainExplorer(RecordStore<RelationshipRecord> recordStore) {
        this.recordStore = recordStore;
    }

    public RecordSet<RelationshipRecord> exploreRelationshipRecordChainsToDepthTwo(RelationshipRecord record) {
        RecordSet<RelationshipRecord> records = new RecordSet<RelationshipRecord>();
        for (RelationshipNodeField nodeField : RelationshipNodeField.values()) {
            long nodeId = nodeField.get(record);
            records.addAll(this.expandChains(this.expandChainInBothDirections(record, nodeId), nodeId));
        }
        return records;
    }

    private RecordSet<RelationshipRecord> expandChains(RecordSet<RelationshipRecord> records, long otherNodeId) {
        RecordSet<RelationshipRecord> chains = new RecordSet<RelationshipRecord>();
        for (RelationshipRecord record : records) {
            chains.addAll(this.expandChainInBothDirections(record, record.getFirstNode() == otherNodeId ? record.getSecondNode() : record.getFirstNode()));
        }
        return chains;
    }

    private RecordSet<RelationshipRecord> expandChainInBothDirections(RelationshipRecord record, long nodeId) {
        return this.expandChain(record, nodeId, RelationshipChainDirection.PREV).union(this.expandChain(record, nodeId, RelationshipChainDirection.NEXT));
    }

    protected RecordSet<RelationshipRecord> followChainFromNode(long nodeId, long relationshipId) {
        RelationshipRecord record = (RelationshipRecord)this.recordStore.getRecord(relationshipId);
        return this.expandChain(record, nodeId, RelationshipChainDirection.NEXT);
    }

    private RecordSet<RelationshipRecord> expandChain(RelationshipRecord record, long nodeId, RelationshipChainDirection direction) {
        RecordSet<RelationshipRecord> chain = new RecordSet<RelationshipRecord>();
        chain.add(record);
        RelationshipRecord currentRecord = record;
        long nextRelId = direction.fieldFor(nodeId, currentRecord).relOf(currentRecord);
        while (currentRecord.inUse() && !direction.fieldFor(nodeId, currentRecord).endOfChain(currentRecord)) {
            currentRecord = (RelationshipRecord)this.recordStore.forceGetRecord(nextRelId);
            chain.add(currentRecord);
            nextRelId = direction.fieldFor(nodeId, currentRecord).relOf(currentRecord);
        }
        return chain;
    }
}

