/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Arrays;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class ChainCheck<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
implements ComparativeRecordChecker<RECORD, PropertyRecord, REPORT> {
    private static final int MAX_BLOCK_PER_RECORD_COUNT = 4;
    private final PrimitiveIntSet keys = Primitive.intSet();

    @Override
    public void checkReference(RECORD record, PropertyRecord property, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        for (int key : ChainCheck.keys(property)) {
            if (this.keys.add(key)) continue;
            ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyKeyNotUniqueInChain();
        }
        if (!Record.NO_NEXT_PROPERTY.is(property.getNextProp())) {
            engine.comparativeCheck(records.property(property.getNextProp()), this);
        }
    }

    private static int[] keys(PropertyRecord property) {
        int[] toStartWith = new int[4];
        int index = 0;
        for (PropertyBlock propertyBlock : property) {
            toStartWith[index++] = propertyBlock.getKeyIndexId();
        }
        return Arrays.copyOf(toStartWith, index);
    }
}

