/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.report.InconsistencyLogger;
import org.neo4j.helpers.ObjectUtil;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.util.StringLogger;

public class InconsistencyMessageLogger
implements InconsistencyLogger {
    private final StringLogger logger;
    private static final String ERROR = "ERROR:";
    private static final String WARNING = "WARNING:";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String TAB = "\t";

    public InconsistencyMessageLogger(StringLogger logger) {
        this.logger = logger;
    }

    @Override
    public void error(RecordType recordType, AbstractBaseRecord record, String message, Object ... args) {
        this.log(InconsistencyMessageLogger.record(InconsistencyMessageLogger.entry(ERROR, message), record), args);
    }

    @Override
    public void error(RecordType recordType, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, String message, Object ... args) {
        this.log(InconsistencyMessageLogger.diff(InconsistencyMessageLogger.entry(ERROR, message), oldRecord, newRecord), args);
    }

    @Override
    public void warning(RecordType recordType, AbstractBaseRecord record, String message, Object ... args) {
        this.log(InconsistencyMessageLogger.record(InconsistencyMessageLogger.entry(WARNING, message), record), args);
    }

    @Override
    public void warning(RecordType recordType, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, String message, Object ... args) {
        this.log(InconsistencyMessageLogger.diff(InconsistencyMessageLogger.entry(WARNING, message), oldRecord, newRecord), args);
    }

    private static StringBuilder entry(String type, String message) {
        StringBuilder log = new StringBuilder(type);
        for (String line : message.split("\n")) {
            log.append(' ').append(line.trim());
        }
        return log;
    }

    private static StringBuilder record(StringBuilder log, AbstractBaseRecord record) {
        return log.append(LINE_SEPARATOR).append(TAB).append(record);
    }

    private static StringBuilder diff(StringBuilder log, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord) {
        return log.append(LINE_SEPARATOR).append(TAB).append("- ").append(oldRecord).append(LINE_SEPARATOR).append(TAB).append("+ ").append(newRecord);
    }

    private void log(StringBuilder log, Object[] args) {
        if (args != null && args.length > 0) {
            log.append(LINE_SEPARATOR).append(TAB).append("Inconsistent with:");
            for (Object arg : args) {
                log.append(' ').append(ObjectUtil.toString((Object)arg));
            }
        }
        this.logger.logMessage(log.toString(), true);
    }
}

