/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.util.Providers;

public class PropertyReader {
    private final PropertyStore propertyStore;

    public PropertyReader(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public List<PropertyBlock> propertyBlocks(NodeRecord nodeRecord) {
        Collection records = this.propertyStore.getPropertyRecordChain(nodeRecord.getNextProp());
        ArrayList<PropertyBlock> propertyBlocks = new ArrayList<PropertyBlock>();
        for (PropertyRecord record : records) {
            propertyBlocks.addAll(record.getPropertyBlocks());
        }
        return propertyBlocks;
    }

    public DefinedProperty propertyValue(PropertyBlock block) {
        return block.getType().readProperty(block.getKeyIndexId(), block, Providers.singletonProvider((Object)this.propertyStore));
    }
}

