/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.index.lucene.LuceneLabelScanStoreBuilder;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.LifecycledPageCache;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class ConsistencyCheckService {
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(String storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, StringLogger logger) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        Monitors monitors = new Monitors();
        tuningConfiguration = StoreFactory.configForStoreDir((Config)tuningConfiguration, (File)new File(storeDir));
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory((FileSystemAbstraction)fileSystem);
        LifecycledPageCache pageCache = new LifecycledPageCache((PageSwapperFactory)swapperFactory, (JobScheduler)jobScheduler, tuningConfiguration, PageCacheMonitor.NULL);
        StoreFactory factory = new StoreFactory(tuningConfiguration, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (PageCache)pageCache, (FileSystemAbstraction)fileSystem, logger, monitors);
        jobScheduler.init();
        pageCache.start();
        File reportFile = this.chooseReportPath(tuningConfiguration);
        StringLogger report = StringLogger.lazyLogger((File)reportFile);
        try (NeoStore neoStore = factory.newNeoStore(false, false);){
            neoStore.makeStoreOk();
            StoreAccess store = new StoreAccess(neoStore);
            LabelScanStore labelScanStore = null;
            try {
                labelScanStore = new LuceneLabelScanStoreBuilder(storeDir, store.getRawNeoStore(), (FileSystemAbstraction)fileSystem, logger).build();
                LuceneSchemaIndexProvider indexes = new LuceneSchemaIndexProvider(DirectoryFactory.PERSISTENT, tuningConfiguration);
                DirectStoreAccess stores = new DirectStoreAccess(store, labelScanStore, (SchemaIndexProvider)indexes);
                FullCheck check = new FullCheck(tuningConfiguration, progressFactory);
                summary = check.execute(stores, StringLogger.tee((StringLogger)logger, (StringLogger)report));
            }
            finally {
                try {
                    if (null != labelScanStore) {
                        labelScanStore.shutdown();
                    }
                }
                catch (IOException e) {
                    logger.error("Failure during shutdown of label scan store", (Throwable)e);
                }
            }
        }
        finally {
            report.close();
            try {
                pageCache.stop();
            }
            catch (IOException e) {
                logger.error("Failure during shutdown of the page cache", (Throwable)e);
            }
            jobScheduler.shutdown();
        }
        if (!summary.isConsistent()) {
            logger.logMessage(String.format("See '%s' for a detailed consistency report.", reportFile.getPath()));
            return Result.FAILURE;
        }
        return Result.SUCCESS;
    }

    private File chooseReportPath(Config tuningConfiguration) {
        File reportPath = (File)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_report_file);
        if (reportPath == null) {
            return new File((File)tuningConfiguration.get(GraphDatabaseSettings.store_dir), ConsistencyCheckService.defaultLogFileName(this.timestamp));
        }
        if (reportPath.isDirectory()) {
            return new File(reportPath, ConsistencyCheckService.defaultLogFileName(this.timestamp));
        }
        return reportPath;
    }

    public static String defaultLogFileName(Date date) {
        String formattedDate = new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date);
        return String.format("inconsistencies-%s.report", formattedDate);
    }

    public static enum Result {
        FAILURE(false),
        SUCCESS(true);

        private final boolean successful;

        private Result(boolean successful) {
            this.successful = successful;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

