/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.StoppableRunnable;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.progress.Completion;

public enum TaskExecutionOrder {
    MULTI_THREADED{

        @Override
        void execute(List<StoppableRunnable> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new NamedThreadFactory("consistency-checker-task"));
            for (StoppableRunnable task : tasks) {
                executor.submit(task);
            }
            try {
                completion.await(7L, TimeUnit.DAYS);
            }
            catch (Exception e) {
                tasks.get(0).stopScanning();
                throw new ConsistencyCheckIncompleteException(e);
            }
            finally {
                executor.shutdown();
                try {
                    executor.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {}
            }
        }
    }
    ,
    SINGLE_THREADED{

        @Override
        void execute(List<StoppableRunnable> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            try {
                for (StoppableRunnable task : tasks) {
                    task.run();
                }
                completion.await(0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new ConsistencyCheckIncompleteException(e);
            }
        }
    }
    ,
    MULTI_PASS{

        @Override
        void execute(List<StoppableRunnable> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            try {
                for (StoppableRunnable task : tasks) {
                    task.run();
                }
                completion.await(0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new ConsistencyCheckIncompleteException(e);
            }
        }
    };


    abstract void execute(List<StoppableRunnable> var1, Completion var2) throws ConsistencyCheckIncompleteException;
}

